<?php
/**
 * Erweiterte Suche nach Drucker "PRT17"
 * Sucht auch in Netzwerkdruckern und Druckerservern
 */

echo "=== ERWEITERTE SUCHE NACH DRUCKER 'PRT17' ===\n\n";

$found = false;
$all_results = [];

// 1. Lokale Drucker
echo "1. LOKALE DRUCKER:\n";
echo str_repeat("-", 50) . "\n";

exec('wmic printer get name,driverName,portName,shared,network /format:list', $output);

$current_printer = [];
foreach ($output as $line) {
    $line = trim($line);
    if (empty($line)) {
        if (!empty($current_printer)) {
            $name = $current_printer['name'] ?? '';
            if (stripos($name, 'PRT17') !== false) {
                echo "✅ GEFUNDEN: $name\n";
                echo "   Treiber: " . ($current_printer['driver'] ?? 'N/A') . "\n";
                echo "   Port: " . ($current_printer['port'] ?? 'N/A') . "\n";
                echo "   Shared: " . ($current_printer['shared'] ?? 'N/A') . "\n";
                echo "   Network: " . ($current_printer['network'] ?? 'N/A') . "\n";
                $all_results[] = $current_printer;
                $found = true;
            }
            $current_printer = [];
        }
        continue;
    }
    
    if (strpos($line, 'Name=') === 0) {
        $current_printer['name'] = substr($line, 5);
    } elseif (strpos($line, 'driverName=') === 0) {
        $current_printer['driver'] = substr($line, 11);
    } elseif (strpos($line, 'portName=') === 0) {
        $current_printer['port'] = substr($line, 9);
    } elseif (strpos($line, 'Shared=') === 0) {
        $current_printer['shared'] = substr($line, 7);
    } elseif (strpos($line, 'Network=') === 0) {
        $current_printer['network'] = substr($line, 8);
    }
}

if (!empty($current_printer)) {
    $name = $current_printer['name'] ?? '';
    if (stripos($name, 'PRT17') !== false) {
        echo "✅ GEFUNDEN: $name\n";
        $all_results[] = $current_printer;
        $found = true;
    }
}

if (!$found) {
    echo "❌ Kein Drucker mit 'PRT17' gefunden\n";
}

// 2. Alle Drucker auflisten (zur Kontrolle)
echo "\n2. ALLE VERFÜGBAREN DRUCKER:\n";
echo str_repeat("-", 50) . "\n";

exec('wmic printer get name', $all_printers);
foreach ($all_printers as $printer) {
    $printer = trim($printer);
    if (!empty($printer) && $printer !== 'Name') {
        $marker = stripos($printer, 'PRT17') !== false ? ' ⭐ PRT17!' : '';
        echo "  - $printer$marker\n";
    }
}

// 3. Netzwerkdrucker suchen
echo "\n3. NETZWERKDRUCKER:\n";
echo str_repeat("-", 50) . "\n";

// Versuche verschiedene Methoden
$network_methods = [
    'wmic printer where "network=true" get name',
    'powershell -Command "Get-Printer | Where-Object {$_.Type -eq \'Network\'} | Select-Object Name"',
];

foreach ($network_methods as $method) {
    exec($method, $network_output);
    if (!empty($network_output)) {
        foreach ($network_output as $line) {
            $line = trim($line);
            if (!empty($line) && stripos($line, 'PRT17') !== false) {
                echo "✅ Netzwerkdrucker gefunden: $line\n";
                $found = true;
            }
        }
    }
}

// 4. Druckerserver durchsuchen
echo "\n4. DRUCKERSERVER:\n";
echo str_repeat("-", 50) . "\n";

// Versuche Druckerserver zu finden
exec('wmic printjob get name,printername', $printjobs);
foreach ($printjobs as $line) {
    if (stripos($line, 'PRT17') !== false) {
        echo "✅ In Druckaufträgen gefunden: $line\n";
    }
}

// 5. Registry durchsuchen (auch entfernte Drucker)
echo "\n5. REGISTRY-DURCHSUCHUNG:\n";
echo str_repeat("-", 50) . "\n";

exec('reg query "HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Print\Printers" /s /v Name', $reg_output);

foreach ($reg_output as $line) {
    if (stripos($line, 'PRT17') !== false) {
        echo "✅ In Registry gefunden: $line\n";
        $found = true;
    }
}

// 6. Suche nach ähnlichen Namen
echo "\n6. ÄHNLICHE NAMEN (PRT, 17, Printer):\n";
echo str_repeat("-", 50) . "\n";

exec('wmic printer get name', $similar);
$similar_found = false;
foreach ($similar as $printer) {
    $printer = trim($printer);
    if (!empty($printer) && $printer !== 'Name') {
        if (stripos($printer, 'PRT') !== false || 
            stripos($printer, '17') !== false || 
            stripos($printer, 'Printer') !== false) {
            echo "  - $printer\n";
            $similar_found = true;
        }
    }
}

if (!$similar_found) {
    echo "  (Keine ähnlichen Namen gefunden)\n";
}

// ZUSAMMENFASSUNG
echo "\n" . str_repeat("=", 50) . "\n";
echo "ZUSAMMENFASSUNG:\n";
echo str_repeat("=", 50) . "\n";

if ($found && !empty($all_results)) {
    echo "✅ DRUCKER MIT 'PRT17' GEFUNDEN!\n\n";
    foreach ($all_results as $idx => $printer) {
        echo "Drucker " . ($idx + 1) . ":\n";
        echo "  Name: " . ($printer['name'] ?? 'N/A') . "\n";
        echo "  Treiber: " . ($printer['driver'] ?? 'N/A') . "\n";
        echo "  Port: " . ($printer['port'] ?? 'N/A') . "\n";
        if (isset($printer['network'])) {
            echo "  Netzwerk: " . ($printer['network'] === 'TRUE' ? 'Ja' : 'Nein') . "\n";
        }
        echo "\n";
        
        $printer_name = $printer['name'];
        echo "💡 Verwendung:\n";
        echo "   define('PRINTER_NAME', '$printer_name');\n";
    }
} else {
    echo "❌ KEIN DRUCKER MIT 'PRT17' GEFUNDEN\n\n";
    echo "Mögliche Lösungen:\n";
    echo "  1. Drucker installieren:\n";
    echo "     - Systemsteuerung > Geräte und Drucker > Drucker hinzufügen\n";
    echo "  2. Netzwerkdrucker hinzufügen:\n";
    echo "     - Systemsteuerung > Geräte und Drucker > Drucker hinzufügen > Netzwerkdrucker\n";
    echo "  3. Drucker-Name prüfen:\n";
    echo "     - Möglicherweise heißt der Drucker anders (z.B. 'PRT-17', 'Printer17', etc.)\n";
    echo "  4. Auf anderem Server/Computer:\n";
    echo "     - Der Drucker könnte auf einem anderen Computer installiert sein\n";
    echo "     - Prüfen Sie Druckerserver oder Netzwerk-Freigaben\n";
}

echo "\n";
echo "💡 TIPP: Wenn der Drucker auf einem anderen Computer ist,\n";
echo "   können Sie ihn als Netzwerkdrucker hinzufügen:\n";
echo "   \\\\COMPUTERNAME\\PRT17\n";
echo "   oder\n";
echo "   \\\\IP-ADRESSE\\PRT17\n";

?>

