<?php
/**
 * Sucht nach Netzwerkdruckern auf Servern wie buek-s01
 * Prüft verschiedene Server-Namen und findet alle verfügbaren Drucker
 */

echo "=== NETZWERKDRUCKER-SUCHE ===\n";
echo "Suche nach Druckern auf Netzwerkservern (z.B. buek-s01)\n\n";

// Mögliche Server-Namen (basierend auf "buek-s01")
$possible_servers = [
    'buek-s01',
    'buek-s02',
    'buek-s1',
    'buek-s2',
    'buek-server',
    'buek-print',
    'print-server',
    'printer-server',
    'PRT17-SERVER',
    'PRT17-S01',
    // Auch mit Domain
    'buek-s01.local',
    'buek-s01.domain',
    // IP-Bereiche (anpassen!)
    '192.168.1.100',
    '192.168.0.100',
    '10.0.0.100',
];

// 1. Suche nach bekannten Servern
echo "1. PRÜFE NETZWERKSERVER:\n";
echo str_repeat("-", 50) . "\n";

$found_servers = [];
foreach ($possible_servers as $server) {
    // Teste ob Server erreichbar ist
    $test_cmd = sprintf('ping -n 1 -w 1000 %s 2>nul', escapeshellarg($server));
    exec($test_cmd, $ping_output, $ping_return);
    
    if ($ping_return === 0) {
        echo "✅ Server erreichbar: $server\n";
        $found_servers[] = $server;
    } else {
        // Versuche auch mit \\ Präfix
        $unc_path = "\\\\$server";
        if (@file_exists($unc_path) || @is_dir($unc_path)) {
            echo "✅ Server erreichbar (UNC): $unc_path\n";
            $found_servers[] = $server;
        }
    }
}

// 2. Suche nach Druckern auf gefundenen Servern
echo "\n2. DRUCKER AUF SERVERN:\n";
echo str_repeat("-", 50) . "\n";

$found_printers = [];

foreach ($found_servers as $server) {
    echo "\nServer: $server\n";
    
    // Methode 1: net view
    $net_cmd = sprintf('net view \\\\%s 2>nul', escapeshellarg($server));
    exec($net_cmd, $net_output, $net_return);
    
    if ($net_return === 0) {
        echo "  ✅ Server antwortet\n";
        foreach ($net_output as $line) {
            if (stripos($line, 'PRT') !== false || 
                stripos($line, 'Drucker') !== false || 
                stripos($line, 'Printer') !== false ||
                stripos($line, '17') !== false) {
                echo "  📄 $line\n";
                if (stripos($line, 'PRT17') !== false) {
                    $found_printers[] = "\\\\$server\\PRT17";
                }
            }
        }
    }
    
    // Methode 2: Direkter Zugriff auf Druckerfreigaben
    $printer_paths = [
        "\\\\$server\\PRT17",
        "\\\\$server\\PRT-17",
        "\\\\$server\\Printer17",
        "\\\\$server\\PRT_17",
    ];
    
    foreach ($printer_paths as $path) {
        // Teste ob Drucker erreichbar ist
        $test_cmd = sprintf('net use "%s" 2>&1', $path);
        exec($test_cmd, $test_output, $test_return);
        
        if ($test_return === 0 || stripos(implode(' ', $test_output), 'erfolgreich') !== false) {
            echo "  ✅ Drucker gefunden: $path\n";
            $found_printers[] = $path;
        }
    }
    
    // Methode 3: WMI - Netzwerkdrucker
    $wmi_cmd = sprintf('wmic printer where "portname like \'%%%s%%\'" get name,portname /format:list 2>nul', $server);
    exec($wmi_cmd, $wmi_output);
    foreach ($wmi_output as $line) {
        if (stripos($line, 'PRT17') !== false || (stripos($line, 'PRT') !== false && stripos($line, '17') !== false)) {
            echo "  ✅ WMI gefunden: $line\n";
        }
    }
}

// 3. Suche nach allen Netzwerkdruckern im System
echo "\n3. ALLE NETZWERKDRUCKER IM SYSTEM:\n";
echo str_repeat("-", 50) . "\n";

exec('wmic printer where "network=true" get name,portname,sharename /format:list', $network_printers);
$current = [];
foreach ($network_printers as $line) {
    $line = trim($line);
    if (empty($line)) {
        if (!empty($current)) {
            $name = $current['name'] ?? '';
            $port = $current['port'] ?? '';
            $share = $current['share'] ?? '';
            
            if (stripos($name, 'PRT17') !== false || 
                stripos($port, 'PRT17') !== false || 
                stripos($share, 'PRT17') !== false ||
                (stripos($name, 'PRT') !== false && stripos($name, '17') !== false)) {
                echo "✅ Netzwerkdrucker gefunden:\n";
                echo "   Name: $name\n";
                echo "   Port: $port\n";
                echo "   Freigabe: $share\n";
                if (!empty($share)) {
                    $found_printers[] = $share;
                }
            }
            $current = [];
        }
        continue;
    }
    if (strpos($line, 'Name=') === 0) $current['name'] = substr($line, 5);
    if (strpos($line, 'PortName=') === 0) $current['port'] = substr($line, 9);
    if (strpos($line, 'ShareName=') === 0) $current['share'] = substr($line, 10);
}

// 4. Suche nach allen Druckern mit PRT im Namen
echo "\n4. ALLE DRUCKER MIT 'PRT' IM NAMEN:\n";
echo str_repeat("-", 50) . "\n";

exec('wmic printer get name,portname,sharename /format:list', $all_printers);
$current = [];
foreach ($all_printers as $line) {
    $line = trim($line);
    if (empty($line)) {
        if (!empty($current)) {
            $name = $current['name'] ?? '';
            $port = $current['port'] ?? '';
            $share = $current['share'] ?? '';
            
            if (stripos($name, 'PRT') !== false || 
                stripos($port, 'PRT') !== false || 
                stripos($share, 'PRT') !== false) {
                echo "📄 Drucker: $name\n";
                if (!empty($port)) echo "   Port: $port\n";
                if (!empty($share)) echo "   Freigabe: $share\n";
                if (stripos($name, '17') !== false || stripos($port, '17') !== false) {
                    echo "   ⭐ Enthält '17' - könnte PRT17 sein!\n";
                    if (!empty($share)) {
                        $found_printers[] = $share;
                    } elseif (!empty($name)) {
                        $found_printers[] = $name;
                    }
                }
            }
            $current = [];
        }
        continue;
    }
    if (strpos($line, 'Name=') === 0) $current['name'] = substr($line, 5);
    if (strpos($line, 'PortName=') === 0) $current['port'] = substr($line, 9);
    if (strpos($line, 'ShareName=') === 0) $current['share'] = substr($line, 10);
}

// 5. Anleitung: Wie man im Explorer Netzwerkdrucker findet
echo "\n" . str_repeat("=", 50) . "\n";
echo "ANLEITUNG: NETZWERKDRUCKER IM EXPLORER FINDEN\n";
echo str_repeat("=", 50) . "\n";

echo "\n1. Öffnen Sie den Windows Explorer\n";
echo "2. Geben Sie in der Adressleiste ein:\n";
echo "   \\\\buek-s01\n";
echo "   ODER\n";
echo "   \\\\SERVERNAME\n";
echo "3. Drücken Sie Enter\n";
echo "4. Sie sehen alle Freigaben auf dem Server\n";
echo "5. Suchen Sie nach PRT17 oder ähnlichen Namen\n\n";

echo "ALTERNATIVE:\n";
echo "1. Windows-Taste + R drücken\n";
echo "2. Eingeben: \\\\buek-s01\n";
echo "3. Enter drücken\n";
echo "4. Alle Freigaben werden angezeigt\n\n";

// ZUSAMMENFASSUNG
echo "\n" . str_repeat("=", 50) . "\n";
echo "ZUSAMMENFASSUNG:\n";
echo str_repeat("=", 50) . "\n";

if (!empty($found_printers)) {
    echo "✅ GEFUNDENE DRUCKER:\n\n";
    $unique_printers = array_unique($found_printers);
    foreach ($unique_printers as $idx => $printer) {
        echo ($idx + 1) . ". $printer\n";
    }
    
    echo "\n💡 VERWENDUNG IN PHP:\n";
    echo str_repeat("-", 50) . "\n";
    foreach ($unique_printers as $printer) {
        if (stripos($printer, 'PRT17') !== false) {
            echo "   define('PRINTER_NAME', '$printer');\n";
            break;
        }
    }
} else {
    echo "❌ KEINE DRUCKER MIT PRT17 GEFUNDEN\n\n";
    echo "NÄCHSTE SCHRITTE:\n";
    echo "1. Öffnen Sie den Windows Explorer\n";
    echo "2. Geben Sie in der Adressleiste ein: \\\\buek-s01\n";
    echo "3. Suchen Sie nach PRT17 in der Liste\n";
    echo "4. Kopieren Sie den exakten UNC-Pfad (z.B. \\\\buek-s01\\PRT17)\n";
    echo "5. Verwenden Sie diesen Pfad in PHP:\n";
    echo "   define('PRINTER_NAME', '\\\\buek-s01\\PRT17');\n";
}

echo "\n";
echo "💡 TIPP: Wenn Sie den Server-Namen nicht mehr wissen,\n";
echo "   können Sie auch versuchen:\n";
echo "   - \\\\buek-s01\n";
echo "   - \\\\print-server\n";
echo "   - \\\\printer-server\n";
echo "   Oder fragen Sie Deniz Uludag nach dem Server-Namen\n";

?>

