<?php
/**
 * Sucht nach Druckern auf \\buek-s01
 * Versucht verschiedene Methoden, um alle Druckerfreigaben zu finden
 */

echo "=== SUCHE NACH DRUCKERN AUF \\\\buek-s01 ===\n\n";

$server = 'buek-s01';
$unc_path = "\\\\$server";

// 1. Teste ob Server erreichbar ist
echo "1. SERVER-ERREICHBARKEIT:\n";
echo str_repeat("-", 50) . "\n";

$ping_cmd = sprintf('ping -n 1 -w 1000 %s 2>nul', escapeshellarg($server));
exec($ping_cmd, $ping_output, $ping_return);

if ($ping_return === 0) {
    echo "✅ Server $server ist erreichbar (ping erfolgreich)\n";
} else {
    echo "⚠️  Server $server nicht per ping erreichbar\n";
    echo "   (Das bedeutet nicht, dass er nicht erreichbar ist)\n";
}

// 2. Versuche UNC-Pfad zu öffnen
echo "\n2. UNC-PFAD ZUGRIFF:\n";
echo str_repeat("-", 50) . "\n";

if (@file_exists($unc_path) || @is_dir($unc_path)) {
    echo "✅ UNC-Pfad erreichbar: $unc_path\n";
} else {
    echo "⚠️  UNC-Pfad nicht direkt erreichbar: $unc_path\n";
    echo "   (Möglicherweise benötigen Sie Authentifizierung)\n";
}

// 3. Net View - Liste alle Freigaben
echo "\n3. NET VIEW - ALLE FREIGABEN:\n";
echo str_repeat("-", 50) . "\n";

$net_cmd = sprintf('net view "%s" 2>&1', $unc_path);
exec($net_cmd, $net_output, $net_return);

if ($net_return === 0 && !empty($net_output)) {
    echo "✅ Freigaben gefunden:\n\n";
    $printers = [];
    foreach ($net_output as $line) {
        $line = trim($line);
        if (!empty($line) && 
            stripos($line, 'PRT') !== false || 
            stripos($line, 'Drucker') !== false || 
            stripos($line, 'Printer') !== false ||
            stripos($line, 'Print') !== false) {
            echo "  📄 $line\n";
            
            // Extrahiere Druckernamen
            if (preg_match('/\s+([A-Z0-9_-]+)\s+/i', $line, $matches)) {
                $printer_name = $matches[1];
                if (stripos($printer_name, 'PRT') !== false || 
                    stripos($printer_name, '17') !== false ||
                    stripos($line, 'Drucker') !== false) {
                    $printers[] = "$unc_path\\$printer_name";
                }
            }
        } elseif (!empty($line) && stripos($line, 'Freigabename') === false && stripos($line, '---') === false) {
            // Zeige auch andere Freigaben (könnten Drucker sein)
            echo "  📁 $line\n";
        }
    }
    
    if (!empty($printers)) {
        echo "\n✅ Mögliche Drucker-Pfade:\n";
        foreach ($printers as $printer) {
            echo "   $printer\n";
        }
    }
} else {
    echo "❌ Konnte Freigaben nicht abrufen\n";
    echo "   Fehler: " . implode(' ', $net_output) . "\n";
    echo "\n💡 Mögliche Gründe:\n";
    echo "   - Server ist nicht erreichbar\n";
    echo "   - Authentifizierung erforderlich\n";
    echo "   - Firewall blockiert Zugriff\n";
    echo "   - Server-Name ist anders\n";
}

// 4. Versuche bekannte Druckernamen
echo "\n4. TESTE BEKANNTE DRUCKERNAMEN:\n";
echo str_repeat("-", 50) . "\n";

$known_printers = [
    'PRT17',
    'PRT-17',
    'PRT_17',
    'Printer17',
    'Printer-17',
    'PRT017',
    'PRT17-01',
];

foreach ($known_printers as $printer_name) {
    $printer_path = "$unc_path\\$printer_name";
    
    // Teste ob Drucker erreichbar ist
    $test_cmd = sprintf('net use "%s" 2>&1', $printer_path);
    exec($test_cmd, $test_output, $test_return);
    
    if ($test_return === 0 || stripos(implode(' ', $test_output), 'erfolgreich') !== false) {
        echo "✅ GEFUNDEN: $printer_path\n";
    } else {
        // Versuche auch mit print-Befehl
        $test_file = sys_get_temp_dir() . '\\test_prt17.txt';
        @file_put_contents($test_file, "Test\n");
        
        $print_cmd = sprintf('print /D:"%s" "%s" 2>&1', $printer_path, $test_file);
        exec($print_cmd, $print_output, $print_return);
        
        if ($print_return === 0) {
            echo "✅ GEFUNDEN (druckbar): $printer_path\n";
        }
        
        @unlink($test_file);
    }
}

// 5. Anleitung
echo "\n" . str_repeat("=", 50) . "\n";
echo "ANLEITUNG: DRUCKER IM EXPLORER FINDEN\n";
echo str_repeat("=", 50) . "\n";

echo "\nMETHODE 1: Windows Explorer\n";
echo "1. Öffnen Sie den Windows Explorer\n";
echo "2. Klicken Sie in die Adressleiste\n";
echo "3. Geben Sie ein: \\\\buek-s01\n";
echo "4. Drücken Sie Enter\n";
echo "5. Sie sehen alle Freigaben auf dem Server\n";
echo "6. Suchen Sie nach PRT17 oder ähnlichen Namen\n";
echo "7. Rechtsklick auf PRT17 > Drucker verbinden\n\n";

echo "METHODE 2: Ausführen-Dialog\n";
echo "1. Windows-Taste + R drücken\n";
echo "2. Eingeben: \\\\buek-s01\n";
echo "3. Enter drücken\n";
echo "4. Alle Freigaben werden angezeigt\n\n";

echo "METHODE 3: Kommandozeile\n";
echo "1. Öffnen Sie cmd oder PowerShell\n";
echo "2. Eingeben: net view \\\\buek-s01\n";
echo "3. Enter drücken\n";
echo "4. Liste aller Freigaben wird angezeigt\n\n";

// ZUSAMMENFASSUNG
echo "\n" . str_repeat("=", 50) . "\n";
echo "ZUSAMMENFASSUNG:\n";
echo str_repeat("=", 50) . "\n";

echo "\n💡 WENN SIE PRT17 GEFUNDEN HABEN:\n";
echo "   Verwenden Sie den UNC-Pfad in PHP:\n";
echo "   define('PRINTER_NAME', '\\\\buek-s01\\PRT17');\n";
echo "\n";
echo "💡 WENN DER SERVER-NAME ANDERS IST:\n";
echo "   Versuchen Sie:\n";
echo "   - \\\\buek-s02\n";
echo "   - \\\\buek-server\n";
echo "   - \\\\print-server\n";
echo "   - \\\\printer-server\n";
echo "   Oder fragen Sie Deniz Uludag nach dem exakten Server-Namen\n";

?>

