@echo off
setlocal ENABLEDELAYEDEXPANSION

REM ================== Einstellungen & Hilfe ==================
if "%~1"=="" (
  echo Nutzung:
  echo   exshowroom_fetch_curl.bat "https://ex-showroom.de/vs-ex90.gltf" [.\out] [--hdr-only] [--headers-cfg headers.cfg]
  echo.
  echo Beispiele:
  echo   exshowroom_fetch_curl.bat "https://ex-showroom.de/vs-ex90.gltf" .\ex90
  echo   exshowroom_fetch_curl.bat "https://ex-showroom.de/vs-ex90.gltf" .\ex90 --hdr-only
  echo   exshowroom_fetch_curl.bat "https://ex-showroom.de/vs-ex90.gltf" .\ex90 --headers-cfg headers.cfg
  echo.
  echo ^(Hinweis: headers.cfg ist eine CURL-Config mit Zeilen:  header = "Name: Wert"^)
  pause
  exit /b 1
)

set "GLTF_URL=%~1"
set "OUT_DIR=%~2"
if "%OUT_DIR%"=="" set "OUT_DIR=.\downloaded_model"

set "HDR_ONLY=0"
set "HEADERS_CFG="

if /I "%~3"=="--hdr-only" set "HDR_ONLY=1"
if /I "%~3"=="--headers-cfg" set "HEADERS_CFG=%~4"
if /I "%~5"=="--hdr-only" set "HDR_ONLY=1"
if /I "%~5"=="--headers-cfg" set "HEADERS_CFG=%~6"

REM ================== Tools pruefen ==================
where curl >nul 2>nul
if errorlevel 1 (
  echo [FEHLER] curl.exe nicht gefunden. Bitte unter Windows 10/11 verwenden oder CURL installieren.
  pause
  exit /b 1
)
if not exist "%~dp0jq.exe" (
  echo [FEHLER] jq.exe nicht gefunden. Lege jq.exe neben diese .bat.
  echo Download: https://jq.io (Windows 64-bit), Datei als "jq.exe" speichern.
  pause
  exit /b 1
)

REM ================== Pfade / Dateien ==================
for %%A in ("%GLTF_URL%") do set "GLTF_NAME=%%~nxA"
for /f "tokens=1,* delims=?" %%A in ("%GLTF_URL%") do set "GLTF_NOQS=%%A"
for %%A in ("%GLTF_NOQS%") do set "BASE_URL=%%~dpA"
REM BASE_URL hat Backslashes; fuer URLs auf Slash drehen:
set "BASE_URL=%BASE_URL:\=/%"
REM evtl. fuehrendes Laufwerk wie C: entfernen
if not "%BASE_URL:~1,1%"==":" goto _okbase
set "BASE_URL=%BASE_URL:~2%"
:_okbase
REM sicherstellen, dass BASE_URL nicht leer ist
if "%BASE_URL%"=="" (
  echo [FEHLER] Konnte Basis-URL nicht bestimmen.
  pause & exit /b 1
)

if not exist "%OUT_DIR%" mkdir "%OUT_DIR%" >nul 2>&1

set "LOCAL_GLTF=%OUT_DIR%\%GLTF_NAME%"
set "TMP_ALL=%OUT_DIR%\uris_all.txt"
set "TMP_BUFF=%OUT_DIR%\uris_buffers.txt"
set "TMP_HDR=%OUT_DIR%\uris_hdr.txt"

REM ================== GLTF laden ==================
echo [INFO] Lade GLTF: %GLTF_URL%
if not "%HEADERS_CFG%"=="" (
  curl -fL --retry 2 --retry-delay 1 --config "%HEADERS_CFG%" -o "%LOCAL_GLTF%" "%GLTF_URL%"
) else (
  curl -fL --retry 2 --retry-delay 1 -o "%LOCAL_GLTF%" "%GLTF_URL%"
)
if errorlevel 1 (
  echo [FEHLER] Download der GLTF fehlgeschlagen.
  pause & exit /b 1
)
echo [OK] GLTF gespeichert: %LOCAL_GLTF%

REM ================== URIs sammeln (mit jq) ==================
REM Alle URIs (buffers, images, extensions) -> TMP_ALL
"%~dp0jq.exe" -r ^
  "def alluris: (.buffers[]?.uri), (.images[]?.uri), (..|objects|.uri?);
   [ alluris | select(. != null) | select(startswith(\"data:\")|not) ] | unique | .[]" ^
  "%LOCAL_GLTF%" > "%TMP_ALL%"
if errorlevel 1 (
  echo [FEHLER] jq konnte die GLTF nicht parsen.
  pause & exit /b 1
)

REM Nur Buffer-URIs separat (damit wir sie bei --hdr-only sicher laden)
"%~dp0jq.exe" -r ^
  ".buffers[]?.uri | select(. != null) | select(startswith(\"data:\")|not)" ^
  "%LOCAL_GLTF%" > "%TMP_BUFF%" 2>nul

REM ================== Download-Liste bilden ==================
if "%HDR_ONLY%"=="1" (
  REM Filter: nur .hdr aus ALL, plus alle Buffer aus TMP_BUFF
  > "%TMP_HDR%" (
    for /f "usebackq delims=" %%L in ("%TMP_ALL%") do (
      set "L=%%L"
      setlocal ENABLEDELAYEDEXPANSION
      set "low=!L!"
      set "low=!low:~0,-0!"
      REM primitive EndsWith-Pruefung: finde ".hdr" am Ende
      echo !L! | findstr /R /I "\.hdr$" >nul
      if not errorlevel 1 echo !L!
      endlocal
    )
  )
) else (
  REM Kein HDR-Filter: wir benutzen direkt ALL
)

REM ================== Download-Schleife ==================
echo [INFO] Starte Downloads ...

if "%HDR_ONLY%"=="1" (
  REM Zuerst alle Buffer
  for /f "usebackq delims=" %%R in ("%TMP_BUFF%") do (
    call :_download "%%~R"
  )
  REM Dann HDR-Images
  for /f "usebackq delims=" %%R in ("%TMP_HDR%") do (
    call :_download "%%~R"
  )
) else (
  REM Alle URIs
  for /f "usebackq delims=" %%R in ("%TMP_ALL%") do (
    call :_download "%%~R"
  )
)

echo [OK] Fertig. Ordner: %OUT_DIR%
echo.
echo Optional ^(GLB-Konvertierung, Node-Tool erforderlich^):
echo   npm install -g gltf-pipeline
echo   gltf-pipeline -i "%LOCAL_GLTF%" -o "%LOCAL_GLTF:.gltf=.glb%"
echo.
pause
exit /b 0

REM ================== Funktionen ==================
:_download
set "REL=%~1"
if "%REL%"=="" goto :eof

REM Absolute URLs direkt nehmen
set "ISHTTP=%REL:~0,4%"
if /I "%ISHTTP%"=="http" (
  set "FILEURL=%REL%"
) else (
  REM Relativ: mit BASE_URL kombinieren
  set "REL_URL=%REL:\=/%"
  if "%BASE_URL:~-1%"=="/" (
    set "FILEURL=%BASE_URL%%REL_URL%"
  ) else (
    set "FILEURL=%BASE_URL%/%REL_URL%"
  )
)

REM Zielpfad lokal inkl. Unterordner
set "DST=%OUT_DIR%\%REL%"
for %%D in ("%DST%") do if not exist "%%~dpD" mkdir "%%~dpD" >nul 2>&1

echo   [DL ] %FILEURL%
if not "%HEADERS_CFG%"=="" (
  curl -fL --retry 2 --retry-delay 1 --config "%HEADERS_CFG%" -o "%DST%" "%FILEURL%"
) else (
  curl -fL --retry 2 --retry-delay 1 -o "%DST%" "%FILEURL%"
)
if errorlevel 1 (
  echo   [WARN] Konnte nicht laden: %FILEURL%
) else (
  echo   [OK ] %DST%
)
goto :eof