<?php
/**
 * Direkte URL-Lösung mit Session-Parametern
 * Diese Lösung verwendet die exakte URL-Struktur aus Ihrem Browser
 */

echo "=== DIREKTE URL-LÖSUNG MIT SESSION-PARAMETERN ===\n";

$testConfig = [
    'base_url' => 'https://resy.dtm-reifen.de',
    'username' => 'D.ULUDAG',
    'password' => 'Ikizler123!',
    'working_lgs_id' => '9716706'
];

/**
 * Verwendet die exakte URL-Struktur aus dem Browser-Screenshot
 */
function directUrlApproach($baseUrl, $username, $password, $targetLgsId) {
    echo "--- Schritt 1: Login mit Session-Management ---\n";
    
    $cookieFile = sys_get_temp_dir() . '/resy_direct_url.txt';
    
    // Lösche alte Session
    if (file_exists($cookieFile)) {
        unlink($cookieFile);
    }
    
    $ch = curl_init();
    
    // Optimierte cURL-Konfiguration für RESY
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_COOKIEJAR, $cookieFile);
    curl_setopt($ch, CURLOPT_COOKIEFILE, $cookieFile);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36');
    
    // Wichtige Session-Parameter
    curl_setopt($ch, CURLOPT_COOKIESESSION, false);
    curl_setopt($ch, CURLOPT_FRESH_CONNECT, false);
    curl_setopt($ch, CURLOPT_AUTOREFERER, true);
    curl_setopt($ch, CURLOPT_MAXREDIRS, 10);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 15);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    
    // Login durchführen
    $loginUrl = $baseUrl . '/index.php?m=login&a=login';
    curl_setopt($ch, CURLOPT_URL, $loginUrl);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8',
        'Accept-Language: de-DE,de;q=0.9,en-US;q=0.8,en;q=0.7',
        'Accept-Encoding: gzip, deflate, br, zstd',
        'Connection: keep-alive',
        'Upgrade-Insecure-Requests: 1'
    ]);
    
    $loginPageResponse = curl_exec($ch);
    echo "Login-Seite geladen: " . strlen($loginPageResponse) . " Zeichen\n";
    
    // Login-Daten senden
    $postData = [
        'FN' => 'login',
        'UserName' => $username,
        'Password' => $password,
        'button' => 'submit'
    ];
    
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($postData));
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/x-www-form-urlencoded',
        'Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8',
        'Accept-Language: de-DE,de;q=0.9,en-US;q=0.8,en;q=0.7',
        'Accept-Encoding: gzip, deflate, br, zstd',
        'Connection: keep-alive',
        'Upgrade-Insecure-Requests: 1',
        'Referer: ' . $loginUrl
    ]);
    
    $loginResponse = curl_exec($ch);
    $loginCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $loginFinalUrl = curl_getinfo($ch, CURLINFO_EFFECTIVE_URL);
    
    echo "Login: HTTP $loginCode, Final URL: $loginFinalUrl\n";
    
    // Prüfe Login-Erfolg
    $loginSuccessful = strpos($loginResponse, 'Anmeldename') === false && 
                      strpos($loginFinalUrl, 'login') === false;
    
    if (!$loginSuccessful) {
        curl_close($ch);
        throw new Exception("Login fehlgeschlagen");
    }
    
    echo "✅ Login erfolgreich!\n";
    
    echo "--- Schritt 2: Verwende exakte URL-Struktur aus Browser-Screenshot ---\n";
    
    // Verwende die exakte URL-Struktur aus dem Screenshot
    // https://resy.dtm-reifen.de/resyweb/index.php?FN=WheelsetSearch&a=search&m=wheelset&LGS_ID=9877092&...
    $directSearchUrl = $baseUrl . '/resyweb/index.php?' . http_build_query([
        'FN' => 'WheelsetSearch',
        'a' => 'search',
        'm' => 'wheelset',
        'LGS_ID' => $targetLgsId,
        'KENNZEICHEN' => '',
        'FAHRGESTNR' => '',
        'BEZEICHNUNG' => '',
        'KDNR' => '',
        'NAME1' => '',
        'EXTDTANR' => '',
        'KD_ID' => '',
        'SERV_ID' => '',
        'STATUS_ID' => '20',
        'SAIS_ID' => '',
        'FROMEINGANGFROM' => '',
        'TOEINGANGTO' => '',
        'FROMPRUEFUNGERLEGIGTFROM' => '',
        'TOPRUEFUNGERLEGIGTTO' => '',
        'RUECKKDNAME' => '',
        'FROMRUECKLIEFERTERMINFROM' => '',
        'TORUECKLIEFERTERMINTO' => '',
        'FROMAUSGANGFROM' => '',
        'TOAUSGANGTO' => '',
        'RFARTSUCH_ID' => '',
        'FROMMINPROFILFROM' => '',
        'TOMINPROFILTO' => '',
        'MAXEMPFEHL_ID' => '',
        'RFFEHL_FLG' => '',
        'FLGFEHL_FLG' => '',
        'RADKAPFEHL_FLG' => '',
        'button' => 'submit'
    ]);
    
    echo "Direkte Such-URL: $directSearchUrl\n";
    
    curl_setopt($ch, CURLOPT_POST, false);
    curl_setopt($ch, CURLOPT_POSTFIELDS, null);
    curl_setopt($ch, CURLOPT_URL, $directSearchUrl);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8',
        'Accept-Language: de-DE,de;q=0.9,en-US;q=0.8,en;q=0.7',
        'Accept-Encoding: gzip, deflate, br, zstd',
        'Connection: keep-alive',
        'Upgrade-Insecure-Requests: 1',
        'Referer: ' . $loginFinalUrl
    ]);
    
    $searchResponse = curl_exec($ch);
    $searchCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $searchFinalUrl = curl_getinfo($ch, CURLINFO_EFFECTIVE_URL);
    
    echo "Suche: HTTP $searchCode, Final URL: $searchFinalUrl\n";
    echo "Content Length: " . strlen($searchResponse) . " Zeichen\n";
    
    // Speichere die Antwort
    file_put_contents(sys_get_temp_dir() . "/resy_direct_url_result.html", $searchResponse);
    
    curl_close($ch);
    
    // Analysiere die Antwort
    $hasWheelsetData = strpos($searchResponse, 'WheelHALTERNAME') !== false || 
                      strpos($searchResponse, 'WheelKENNZEICHEN') !== false ||
                      strpos($searchResponse, 'WheelFAHRGESTNR') !== false;
    $hasTargetLgsId = strpos($searchResponse, $targetLgsId) !== false;
    $hasLoginForm = strpos($searchResponse, 'Anmeldename') !== false;
    $hasResyContent = strpos($searchResponse, 'RESY') !== false;
    
    echo "\n=== DIREKTE URL-ANALYSE ===\n";
    echo "Enthält Wheelset-Daten: " . ($hasWheelsetData ? 'Ja' : 'Nein') . "\n";
    echo "Enthält Ziel-LGS_ID: " . ($hasTargetLgsId ? 'Ja' : 'Nein') . "\n";
    echo "Ist Login-Seite: " . ($hasLoginForm ? 'Ja' : 'Nein') . "\n";
    echo "Enthält RESY-Content: " . ($hasResyContent ? 'Ja' : 'Nein') . "\n";
    
    if ($hasWheelsetData && $hasTargetLgsId) {
        echo "\n🎉 ERFOLG! Direkte URL-Lösung funktioniert!\n";
        echo "Wheelset-Daten für LGS_ID $targetLgsId gefunden!\n";
        
        // Extrahiere einige Daten
        if (preg_match('/WheelHALTERNAME[^>]*>([^<]+)/', $searchResponse, $matches)) {
            echo "Fahrzeughalter: " . trim($matches[1]) . "\n";
        }
        if (preg_match('/WheelKENNZEICHEN[^>]*>([^<]+)/', $searchResponse, $matches)) {
            echo "Kennzeichen: " . trim($matches[1]) . "\n";
        }
        
        return [
            'success' => true,
            'lgs_id' => $targetLgsId,
            'search_method' => 'direct_url',
            'message' => "LGS_ID $targetLgsId mit direkter URL gefunden",
            'response' => [
                'body' => $searchResponse,
                'http_code' => $searchCode,
                'final_url' => $searchFinalUrl
            ]
        ];
        
    } elseif ($hasLoginForm) {
        throw new Exception("Session verloren - zur Login-Seite umgeleitet");
    } elseif ($hasResyContent) {
        echo "\n⚠️ RESY-Seite erreicht, aber keine Wheelset-Daten\n";
        echo "Die LGS_ID existiert möglicherweise nicht oder hat andere Daten.\n";
        throw new Exception("Keine Wheelset-Daten gefunden");
    } else {
        throw new Exception("Unbekannte Antwort");
    }
}

try {
    echo "Teste direkte URL-Lösung mit LGS_ID: " . $testConfig['working_lgs_id'] . "\n\n";
    
    $result = directUrlApproach(
        $testConfig['base_url'],
        $testConfig['username'],
        $testConfig['password'],
        $testConfig['working_lgs_id']
    );
    
    echo "\n✅ Direkte URL-Lösung erfolgreich!\n";
    echo "Suchmethode: " . $result['search_method'] . "\n";
    echo "Nachricht: " . $result['message'] . "\n";
    
} catch (Exception $e) {
    echo "\n❌ Direkte URL-Lösung fehlgeschlagen: " . $e->getMessage() . "\n";
}

echo "\n=== DIREKTE URL-LÖSUNG ABGESCHLOSSEN ===\n";
echo "HTML-Datei gespeichert in: " . sys_get_temp_dir() . "/resy_direct_url_result.html\n";
?>
