<?php
/**
 * Dekodiere die gzip-komprimierte Antwort und analysiere sie
 */

echo "=== DEKODIERE GZIP-KOMPRIMIERTE ANTWORT ===\n";

$htmlFile = sys_get_temp_dir() . "/resy_real_cookies_result.html";

if (!file_exists($htmlFile)) {
    echo "❌ HTML-Datei nicht gefunden: $htmlFile\n";
    exit;
}

$content = file_get_contents($htmlFile);
echo "Original Content Length: " . strlen($content) . " Zeichen\n";

// Prüfe ob es gzip-komprimiert ist
$isGzipped = substr($content, 0, 2) === "\x1f\x8b";
echo "Ist gzip-komprimiert: " . ($isGzipped ? 'Ja' : 'Nein') . "\n";

if ($isGzipped) {
    echo "--- Dekodiere gzip-Inhalt ---\n";
    $decodedContent = gzdecode($content);
    
    if ($decodedContent === false) {
        echo "❌ Gzip-Dekodierung fehlgeschlagen\n";
        exit;
    }
    
    echo "Dekodierte Content Length: " . strlen($decodedContent) . " Zeichen\n";
    
    // Speichere die dekodierte Version
    file_put_contents(sys_get_temp_dir() . "/resy_real_cookies_decoded.html", $decodedContent);
    echo "Dekodierte Version gespeichert: " . sys_get_temp_dir() . "/resy_real_cookies_decoded.html\n";
    
    $content = $decodedContent;
} else {
    echo "Inhalt ist nicht gzip-komprimiert\n";
}

echo "\n=== ANALYSE DER DEKODIERTEN ANTWORT ===\n";

// Analysiere den Inhalt
$hasWheelsetData = strpos($content, 'WheelHALTERNAME') !== false || 
                  strpos($content, 'WheelKENNZEICHEN') !== false ||
                  strpos($content, 'WheelFAHRGESTNR') !== false;
$hasTargetLgsId = strpos($content, '9716706') !== false;
$hasLoginForm = strpos($content, 'Anmeldename') !== false;
$hasResyContent = strpos($content, 'RESY') !== false;
$hasSearchResults = strpos($content, 'WheelsetSearchResult') !== false;
$hasSearchForm = strpos($content, '<form') !== false;
$hasTable = strpos($content, '<table') !== false;

echo "Enthält Wheelset-Daten: " . ($hasWheelsetData ? 'Ja' : 'Nein') . "\n";
echo "Enthält Ziel-LGS_ID (9716706): " . ($hasTargetLgsId ? 'Ja' : 'Nein') . "\n";
echo "Ist Login-Seite: " . ($hasLoginForm ? 'Ja' : 'Nein') . "\n";
echo "Enthält RESY-Content: " . ($hasResyContent ? 'Ja' : 'Nein') . "\n";
echo "Enthält Suchergebnisse: " . ($hasSearchResults ? 'Ja' : 'Nein') . "\n";
echo "Enthält Suchformular: " . ($hasSearchForm ? 'Ja' : 'Nein') . "\n";
echo "Enthält Tabelle: " . ($hasTable ? 'Ja' : 'Nein') . "\n";

// Suche nach spezifischen RESY-Elementen
echo "\n=== RESY-SPEZIFISCHE ELEMENTE ===\n";
$resyElements = [
    'Wheelset' => 'Wheelset',
    'LGS_ID' => 'LGS_ID',
    'WheelHALTERNAME' => 'WheelHALTERNAME',
    'WheelKENNZEICHEN' => 'WheelKENNZEICHEN',
    'WheelFAHRGESTNR' => 'WheelFAHRGESTNR',
    'WheelsetView' => 'WheelsetView',
    'WheelsetSearch' => 'WheelsetSearch',
    'WheelsetResult' => 'WheelsetResult',
    'Anmeldename' => 'Anmeldename',
    'Kennwort' => 'Kennwort',
    'login' => 'login',
    'search' => 'search',
    'suchen' => 'suchen',
    'error' => 'error',
    'fehler' => 'fehler',
    'not found' => 'not found',
    'nicht gefunden' => 'nicht gefunden',
    'keine Daten' => 'keine Daten',
    'keine Ergebnisse' => 'keine Ergebnisse'
];

foreach ($resyElements as $element => $label) {
    $count = substr_count($content, $element);
    if ($count > 0) {
        echo "$label: $count Vorkommen\n";
    }
}

// Suche nach Links mit LGS_ID
echo "\n=== LINKS MIT LGS_ID ===\n";
if (preg_match_all('/href=["\'][^"\']*LGS_ID[^"\']*["\']/', $content, $matches)) {
    echo "LGS_ID Links gefunden: " . count($matches[0]) . "\n";
    foreach ($matches[0] as $link) {
        echo "  - $link\n";
    }
} else {
    echo "Keine LGS_ID Links gefunden\n";
}

// Suche nach Tabellen mit Daten
echo "\n=== TABELLEN-ANALYSE ===\n";
if (preg_match_all('/<table[^>]*>(.*?)<\/table>/is', $content, $tableMatches)) {
    echo "Tabellen gefunden: " . count($tableMatches[0]) . "\n";
    
    foreach ($tableMatches[0] as $i => $table) {
        echo "Tabelle " . ($i + 1) . ":\n";
        
        // Zähle Zeilen
        $rowCount = substr_count($table, '<tr');
        echo "  Zeilen: $rowCount\n";
        
        // Suche nach LGS_ID in der Tabelle
        if (strpos($table, '9716706') !== false) {
            echo "  ✅ Enthält Ziel-LGS_ID!\n";
        }
        
        // Suche nach Wheelset-Daten
        if (strpos($table, 'WheelHALTERNAME') !== false || 
            strpos($table, 'WheelKENNZEICHEN') !== false) {
            echo "  ✅ Enthält Wheelset-Daten!\n";
        }
    }
} else {
    echo "Keine Tabellen gefunden\n";
}

// Zeige einen Ausschnitt des HTML-Inhalts
echo "\n=== HTML-AUSSCHNITT (erste 1000 Zeichen) ===\n";
echo substr($content, 0, 1000) . "\n";

echo "\n=== DEKODIERUNG ABGESCHLOSSEN ===\n";
?>
