<?php
// Debug-Script für Parsing-Test
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Simuliere die aktuelle Parsing-Logik
class DebugWheelsetParser {
    
    public function findCustomerNameInHtml($html, $satznummer) {
        echo "<h3>Suche Kundenname für Satznummer: $satznummer</h3>";
        
        // Suche nach dem Kundenname in verschiedenen HTML-Strukturen
        $patterns = [
            // Suche nach Kundenname in der Nähe der Satznummer
            '/Satznummer[^>]*>' . preg_quote($satznummer, '/') . '[^<]*<[^>]*>([^<]+)</',
            // Suche nach Kundenname in divs oder spans
            '/<div[^>]*>([^<]*(?:GmbH|AG|UG|eG|Dr\.|Prof\.|Herr|Frau|von|zu)[^<]*)</i',
            // Suche nach Kundenname in Tabellenzellen
            '/<td[^>]*>([^<]*(?:GmbH|AG|UG|eG|Dr\.|Prof\.|Herr|Frau|von|zu)[^<]*)</i',
            // Suche nach Kundenname in spans
            '/<span[^>]*>([^<]*(?:GmbH|AG|UG|eG|Dr\.|Prof\.|Herr|Frau|von|zu)[^<]*)</i'
        ];
        
        foreach ($patterns as $i => $pattern) {
            echo "<h4>Pattern " . ($i + 1) . ":</h4>";
            echo "<code>" . htmlspecialchars($pattern) . "</code><br>";
            
            if (preg_match($pattern, $html, $matches)) {
                $candidate = trim(strip_tags($matches[1]));
                echo "Gefunden: <strong>$candidate</strong><br>";
                
                if ($this->isValidCustomerName($candidate)) {
                    echo "✅ Gültiger Kundenname!<br>";
                    return $candidate;
                } else {
                    echo "❌ Ungültiger Kundenname<br>";
                }
            } else {
                echo "Kein Match gefunden<br>";
            }
            echo "<br>";
        }
        
        // Fallback: Suche nach allen Textinhalten, die wie Kundennamen aussehen
        echo "<h4>Fallback-Suche:</h4>";
        if (preg_match_all('/>([^<]*(?:GmbH|AG|UG|eG|Dr\.|Prof\.|Herr|Frau|von|zu)[^<]*)</i', $html, $allMatches)) {
            echo "Gefundene Kandidaten:<br>";
            foreach ($allMatches[1] as $candidate) {
                $candidate = trim(strip_tags($candidate));
                echo "- $candidate ";
                if ($this->isValidCustomerName($candidate)) {
                    echo "✅";
                } else {
                    echo "❌";
                }
                echo "<br>";
            }
        }
        
        return '';
    }
    
    public function isValidCustomerName($name) {
        echo "Prüfe: '$name'<br>";
        
        if (empty($name) || strlen($name) < 3) {
            echo "❌ Zu kurz oder leer<br>";
            return false;
        }
        
        // Filtere bekannte Nicht-Kundennamen aus
        $excludePatterns = [
            '/^(Zur|Sofort|bestellen|vormerken)/i',
            '/^[0-9]+$/',
            '/^[A-Z]{1,3}[^<]*[0-9]+[^<]*$/', // Kennzeichen
            '/^[0-9]+\.[0-9]+\.[0-9]+$/', // Satznummer
            '/^[0-9]{2}\.[0-9]{2}\.[0-9]{4}$/', // Datum
            '/^(113 B & E|Kiel|Autohaus|Standort)/i',
            '/^(Winterreifen|Sommerreifen|Reifen)/i',
            '/^(keine Fehler|leichte Fehler|Austausch notwendig)/i'
        ];
        
        foreach ($excludePatterns as $pattern) {
            if (preg_match($pattern, $name)) {
                echo "❌ Ausgeschlossen durch Pattern: $pattern<br>";
                return false;
            }
        }
        
        // Prüfe ob es wie ein Kundenname aussieht
        $isValid = preg_match('/^[A-Za-zäöüßÄÖÜ][A-Za-zäöüßÄÖÜ\s\.\-\&]+$/', $name);
        if ($isValid) {
            echo "✅ Gültiger Kundenname!<br>";
        } else {
            echo "❌ Ungültiges Format<br>";
        }
        
        return $isValid;
    }
}

// Lade die neueste RESY Response
$debugFiles = glob('resy_*response*.html');
if (empty($debugFiles)) {
    die("Keine RESY Response-Dateien gefunden!");
}

$latestFile = array_reduce($debugFiles, function($a, $b) {
    return filemtime($a) > filemtime($b) ? $a : $b;
});

echo "<h1>Parsing-Test für Kundenname-Erkennung</h1>";
echo "<p>Analysiere Datei: <strong>$latestFile</strong></p>";

$html = file_get_contents($latestFile);
$parser = new DebugWheelsetParser();

// Teste mit der ersten gefundenen Satznummer
if (preg_match('/>([0-9]+\.[0-9]+\.[0-9]+)</', $html, $satzMatches)) {
    $satznummer = $satzMatches[1];
    echo "<h2>Teste mit Satznummer: $satznummer</h2>";
    
    $kunde = $parser->findCustomerNameInHtml($html, $satznummer);
    
    if (empty($kunde)) {
        echo "<h3>❌ Kein Kundenname gefunden!</h3>";
    } else {
        echo "<h3>✅ Kundenname gefunden: <strong>$kunde</strong></h3>";
    }
} else {
    echo "<h2>❌ Keine Satznummer gefunden!</h2>";
}
?>
