<?php
// Debugge den Parsing-Flow
require_once 'api/get_stored_wheelsets.php';

// Lade die gespeicherte HTML-Antwort
$htmlFile = sys_get_temp_dir() . '/resy_wheelsets_response_1.html';

if (file_exists($htmlFile)) {
    $html = file_get_contents($htmlFile);
    echo "<h1>Parsing Flow Debug</h1>";
    echo "<p>HTML-Datei gefunden: " . strlen($html) . " bytes</p>";
    
    // Erstelle eine Instanz der Klasse
    $service = new ResyWheelsetService(1);
    
    // Verwende Reflection um die private Methode zu testen
    $reflection = new ReflectionClass($service);
    $parseMethod = $reflection->getMethod('parseWheelsetsFromResponse');
    $parseMethod->setAccessible(true);
    
    // Führe das komplette Parsing aus
    $wheelsets = $parseMethod->invoke($service, $html);
    
    echo "<h2>Komplettes Parsing Ergebnis:</h2>";
    echo "<p>Gefundene Reifensätze: " . count($wheelsets) . "</p>";
    
    if (!empty($wheelsets)) {
        echo "<h3>Erste 5 Reifensätze:</h3>";
        echo "<table border='1'>";
        echo "<tr><th>Satznummer</th><th>Kennzeichen</th><th>Fahrzeug</th><th>Halter</th><th>Eingangsdatum</th></tr>";
        
        foreach (array_slice($wheelsets, 0, 5) as $wheelset) {
            echo "<tr>";
            echo "<td>" . htmlspecialchars($wheelset['satznummer']) . "</td>";
            echo "<td>" . htmlspecialchars($wheelset['kennzeichen']) . "</td>";
            echo "<td>" . htmlspecialchars($wheelset['fahrzeug']) . "</td>";
            echo "<td>" . htmlspecialchars($wheelset['halter']) . "</td>";
            echo "<td>" . htmlspecialchars($wheelset['eingangsdatum']) . "</td>";
            echo "</tr>";
        }
        echo "</table>";
    } else {
        echo "<p style='color: red;'>Keine Reifensätze gefunden!</p>";
    }
    
    // Teste die einzelnen Parsing-Methoden
    echo "<h3>Einzelne Parsing-Methoden Test:</h3>";
    
    // 1. Tabellen-Parsing
    $tableMethod = $reflection->getMethod('parseWheelsetsFromResponse');
    $tableMethod->setAccessible(true);
    
    // Simuliere das Tabellen-Parsing
    $patterns = [
        '/<tbody[^>]*>(.*?)<\/tbody>/s',
        '/<table[^>]*class="[^"]*table[^"]*"[^>]*>(.*?)<\/table>/s',
        '/<table[^>]*>(.*?)<\/table>/s',
        '/<div[^>]*class="[^"]*table[^"]*"[^>]*>(.*?)<\/div>/s'
    ];
    
    $tableFound = false;
    foreach ($patterns as $patternIndex => $pattern) {
        if (preg_match_all($pattern, $html, $matches)) {
            echo "<p>✅ Tabelle gefunden mit Pattern " . ($patternIndex + 1) . ": " . count($matches[1]) . " Tabellen</p>";
            $tableFound = true;
            break;
        }
    }
    
    if (!$tableFound) {
        echo "<p>❌ Keine Tabellen gefunden</p>";
    }
    
    // 2. LGS_ID-Parsing
    $lgsMethod = $reflection->getMethod('parseLgsIdBasedWheelsets');
    $lgsMethod->setAccessible(true);
    $lgsWheelsets = $lgsMethod->invoke($service, $html);
    echo "<p>LGS_ID-Parsing: " . count($lgsWheelsets) . " Reifensätze</p>";
    
    // 3. Div-Parsing
    $divMethod = $reflection->getMethod('parseDivBasedWheelsets');
    $divMethod->setAccessible(true);
    $divWheelsets = $divMethod->invoke($service, $html);
    echo "<p>Div-Parsing: " . count($divWheelsets) . " Reifensätze</p>";
    
    // 4. Fallback-Parsing
    $fallbackMethod = $reflection->getMethod('fallbackParse');
    $fallbackMethod->setAccessible(true);
    $fallbackWheelsets = $fallbackMethod->invoke($service, $html);
    echo "<p>Fallback-Parsing: " . count($fallbackWheelsets) . " Reifensätze</p>";
    
} else {
    echo "<p style='color: red;'>HTML-Datei nicht gefunden: $htmlFile</p>";
}
?>
