<?php
// Debug-Script für Kundenname-Analyse
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Lade die neueste RESY Response
$debugFiles = glob('resy_*response*.html');
if (empty($debugFiles)) {
    die("Keine RESY Response-Dateien gefunden!");
}

$latestFile = array_reduce($debugFiles, function($a, $b) {
    return filemtime($a) > filemtime($b) ? $a : $b;
});

echo "<h1>RESY Kundenname-Analyse</h1>";
echo "<p>Analysiere Datei: <strong>$latestFile</strong></p>";

$html = file_get_contents($latestFile);
echo "<p>HTML-Größe: " . strlen($html) . " Zeichen</p>";

// Suche nach allen möglichen Kundennamen-Kandidaten
echo "<h2>1. Alle Textinhalte mit Buchstaben (mögliche Kundennamen):</h2>";

if (preg_match_all('/>([A-Za-zäöüßÄÖÜ][A-Za-zäöüßÄÖÜ\s\.\-\&]+)</', $html, $matches)) {
    $candidates = array_unique($matches[1]);
    $candidates = array_filter($candidates, function($candidate) {
        $candidate = trim(strip_tags($candidate));
        return strlen($candidate) > 3 && strlen($candidate) < 100;
    });
    
    echo "<ul>";
    foreach (array_slice($candidates, 0, 50) as $candidate) {
        $clean = trim(strip_tags($candidate));
        echo "<li><strong>$clean</strong></li>";
    }
    echo "</ul>";
}

// Suche nach Satznummern und deren Kontext
echo "<h2>2. Satznummern und Kontext:</h2>";
if (preg_match_all('/>([0-9]+\.[0-9]+\.[0-9]+)</', $html, $satzMatches)) {
    foreach (array_slice($satzMatches[1], 0, 5) as $satznummer) {
        echo "<h3>Satznummer: $satznummer</h3>";
        
        // Suche nach Text in der Nähe dieser Satznummer
        $pattern = '/[^>]*' . preg_quote($satznummer, '/') . '[^<]*<[^>]*>([^<]+)</';
        if (preg_match_all($pattern, $html, $contextMatches)) {
            echo "<ul>";
            foreach ($contextMatches[1] as $context) {
                $context = trim(strip_tags($context));
                if (strlen($context) > 2) {
                    echo "<li>$context</li>";
                }
            }
            echo "</ul>";
        }
    }
}

// Suche nach Tabellenstrukturen
echo "<h2>3. Tabellenstruktur-Analyse:</h2>";
if (preg_match_all('/<table[^>]*>(.*?)<\/table>/s', $html, $tableMatches)) {
    echo "<p>Gefundene Tabellen: " . count($tableMatches[1]) . "</p>";
    
    foreach ($tableMatches[1] as $i => $table) {
        echo "<h3>Tabelle " . ($i + 1) . ":</h3>";
        
        // Suche nach Header
        if (preg_match_all('/<th[^>]*>(.*?)<\/th>/s', $table, $headerMatches)) {
            echo "<strong>Header:</strong> ";
            foreach ($headerMatches[1] as $header) {
                $header = trim(strip_tags($header));
                echo "'$header' ";
            }
            echo "<br><br>";
        }
        
        // Suche nach ersten paar Zeilen
        if (preg_match_all('/<tr[^>]*>(.*?)<\/tr>/s', $table, $rowMatches)) {
            echo "<strong>Erste 3 Zeilen:</strong><br>";
            foreach (array_slice($rowMatches[1], 0, 3) as $j => $row) {
                echo "<strong>Zeile " . ($j + 1) . ":</strong> ";
                if (preg_match_all('/<td[^>]*>(.*?)<\/td>/s', $row, $cellMatches)) {
                    foreach ($cellMatches[1] as $cell) {
                        $cell = trim(strip_tags($cell));
                        if (strlen($cell) > 0) {
                            echo "'$cell' | ";
                        }
                    }
                }
                echo "<br>";
            }
        }
    }
}

// Suche nach spezifischen Mustern
echo "<h2>4. Spezifische Muster-Suche:</h2>";

$patterns = [
    'Firmennamen' => '/(?:GmbH|AG|UG|eG|mbH)/i',
    'Personennamen' => '/(?:Dr\.|Prof\.|Herr|Frau|von|zu)/i',
    'Button-Texte' => '/(?:Zur|Sofort|bestellen|vormerken)/i',
    'Autohaus-Text' => '/(?:113 B & E|Kiel|Autohaus)/i',
    'Status-Texte' => '/(?:keine Fehler|leichte Fehler|Austausch notwendig)/i'
];

foreach ($patterns as $name => $pattern) {
    if (preg_match_all($pattern, $html, $matches)) {
        echo "<strong>$name:</strong> ";
        $unique = array_unique($matches[0]);
        foreach (array_slice($unique, 0, 10) as $match) {
            echo "'$match' ";
        }
        echo "<br>";
    }
}

// Zeige rohe HTML-Struktur um Satznummern
echo "<h2>5. HTML um erste Satznummer:</h2>";
if (preg_match('/[^>]*>([0-9]+\.[0-9]+\.[0-9]+)</', $html, $firstSatz)) {
    $satznummer = $firstSatz[1];
    $context = substr($html, max(0, strpos($html, $satznummer) - 1000), 2000);
    echo "<pre>" . htmlspecialchars($context) . "</pre>";
}

echo "<h2>6. Vollständige HTML-Datei:</h2>";
echo "<p><a href='$latestFile' target='_blank'>HTML-Datei öffnen</a></p>";
?>
