const { chromium } = require('playwright');
const activateAllColumns = require('./activate_resy_columns');

async function debugCells() {
    console.log('🚀 Debug-Zellen-Inhalt nach Spaltenaktivierung...\n');
    
    const browser = await chromium.launch({
        headless: false,
        channel: 'chrome'
    });
    
    const page = await browser.newPage();
    
    try {
        await page.goto('https://resy.dtm-reifen.de/index.php?m=login&a=login', { waitUntil: 'networkidle' });
        await page.fill('#InputUser', 'D.ULUDAG');
        await page.fill('#InputPass', 'Ikizler123!');
        await page.click('button[type="submit"]');
        await page.waitForTimeout(8000);
        
        await page.goto('https://resy.dtm-reifen.de/resyweb/index.php?m=wheelset&a=search', { waitUntil: 'networkidle', timeout: 30000 });
        await page.waitForTimeout(3000);
        await page.selectOption('#WheelKD_ID', '453');
        await page.waitForTimeout(1000);
        await page.selectOption('#WheelSTATUS_ID', '20');
        await page.waitForTimeout(1000);
        await page.click('button[type="submit"]');
        await page.waitForTimeout(8000);
        
        // Aktiviere Spalten
        console.log('Aktiviere Spalten...\n');
        await activateAllColumns(page);
        
        // Suche erneut
        console.log('Suche erneut...\n');
        await page.click('button[type="submit"]');
        await page.waitForTimeout(10000);
        
        // Zeige ALLE Zellen der ersten Zeile
        const result = await page.evaluate(() => {
            const firstRow = document.querySelector('table.ResultTable tbody tr');
            const cells = firstRow ? Array.from(firstRow.querySelectorAll('td')) : [];
            
            const cellData = cells.map((cell, index) => ({
                index: index,
                text: cell.textContent.trim(),
                length: cell.textContent.trim().length
            }));
            
            return {
                totalCells: cells.length,
                cells: cellData
            };
        });
        
        console.log(JSON.stringify(result, null, 2));
        
    } catch (error) {
        console.error('❌ Fehler:', error.message);
    } finally {
        await browser.close();
    }
}

debugCells();

