<?php
require 'config/database.php';

$db = new Database();
$pdo = $db->getConnection();

echo "📊 Reifensätze in der Datenbank:\n";
echo str_repeat("=", 60) . "\n\n";

// Gesamtanzahl
$stmt = $pdo->query('SELECT COUNT(*) as count FROM stored_wheelsets');
$count = $stmt->fetch(PDO::FETCH_ASSOC)['count'];
echo "Gesamt: $count Reifensätze\n\n";

// Details
$stmt = $pdo->query('SELECT kennzeichen, marke, modell, oe_nummer, updated_at FROM stored_wheelsets ORDER BY updated_at DESC LIMIT 10');
$results = $stmt->fetchAll(PDO::FETCH_ASSOC);

echo "Letzte 10 Einträge:\n";
foreach ($results as $i => $r) {
    $num = $i + 1;
    $kz = $r['kennzeichen'] ?: 'N/A';
    $marke = $r['marke'] ?: 'N/A';
    $modell = $r['modell'] ?: 'N/A';
    echo "  $num. $kz - $marke $modell\n";
}

echo "\n";

