<?php
/**
 * Volvo ID Token Refresh (manuell)
 * Route: /auth/volvo/refresh
 */

require_once __DIR__ . '/../../util_volvo.php';

volvoStartSession();
header('Content-Type: application/json');

try {
    $refreshToken = $_SESSION['volvo_refresh'] ?? null;
    
    if (!$refreshToken) {
        http_response_code(401);
        echo json_encode([
            'success' => false,
            'error' => 'Kein Refresh Token vorhanden'
        ]);
        exit;
    }
    
    // Token-Refresh mit Rotation
    $tokens = volvoRefreshTokens($refreshToken);
    
    $now = time();
    $_SESSION['volvo_access'] = $tokens['access_token'];
    $_SESSION['volvo_exp'] = $now + ($tokens['expires_in'] ?? 3600);
    
    // Refresh-Rotation: Neues refresh_token speichern falls vorhanden
    if (isset($tokens['refresh_token'])) {
        $_SESSION['volvo_refresh'] = $tokens['refresh_token'];
    }
    
    echo json_encode([
        'success' => true,
        'expires_in' => $tokens['expires_in'] ?? 3600,
        'expires_at' => date('Y-m-d H:i:s', $now + ($tokens['expires_in'] ?? 3600))
    ]);
    
} catch (Exception $e) {
    error_log('Volvo Refresh Error: ' . $e->getMessage());
    
    // Session invalidieren
    unset($_SESSION['volvo_access'], $_SESSION['volvo_refresh'], $_SESSION['volvo_exp']);
    
    http_response_code(401);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage(),
        'redirect' => '/auth/volvo/login.php'
    ]);
}

