<?php
/**
 * Volvo ID OAuth Login Start
 * Route: /auth/volvo/login
 */

require_once __DIR__ . '/../../util_volvo.php';

$demo = isset($_GET['demo']) && $_GET['demo'] === '1';

try {
    $authorizeUrl = volvoBuildAuthorizeUrl($demo);
    
    // Demo-Modus: Direkt weiterleiten (Token bereits in Session)
    if ($demo && !$authorizeUrl) {
        header('Location: /volvo/vehicles.php');
        exit;
    }
    
    if (!$authorizeUrl) {
        throw new Exception('Volvo OAuth Konfiguration fehlt');
    }
    
    header('Location: ' . $authorizeUrl);
    exit;
    
} catch (Exception $e) {
    http_response_code(500);
    header('Content-Type: application/json');
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}

