<?php
/**
 * Volvo ID OAuth Callback
 * Route: /auth/volvo/callback
 */

require_once __DIR__ . '/../../util_volvo.php';
require_once __DIR__ . '/../../config/database.php';

volvoStartSession();

try {
    $code = $_GET['code'] ?? null;
    $state = $_GET['state'] ?? null;
    $error = $_GET['error'] ?? null;
    
    if ($error) {
        throw new Exception('OAuth Fehler: ' . htmlspecialchars($error));
    }
    
    if (!$code || !$state) {
        throw new Exception('Code oder State fehlt');
    }
    
    // State validieren
    if (!volvoValidateState($state)) {
        throw new Exception('State-Validierung fehlgeschlagen');
    }
    
    // Code Verifier aus Session holen
    $codeVerifier = $_SESSION['volvo_code_verifier'] ?? null;
    if (!$codeVerifier) {
        throw new Exception('Code Verifier nicht gefunden');
    }
    unset($_SESSION['volvo_code_verifier']);
    
    // Token tauschen
    $tokens = volvoExchangeCodeForTokens($code, $codeVerifier);
    
    // Tokens in Session speichern
    $now = time();
    $_SESSION['volvo_access'] = $tokens['access_token'];
    $_SESSION['volvo_exp'] = $now + ($tokens['expires_in'] ?? 3600);
    $_SESSION['volvo_refresh'] = $tokens['refresh_token'] ?? null;
    
    // Refresh-Rotation: Neues refresh_token speichern falls vorhanden
    if (isset($tokens['refresh_token'])) {
        $_SESSION['volvo_refresh'] = $tokens['refresh_token'];
    }
    
    // Optional: User-Info aus Token extrahieren (falls vorhanden)
    // Hier könnte man auch die User-ID aus dem Token extrahieren
    
    // Weiterleitung zu Vehicles-Seite
    header('Location: /volvo/vehicles.php');
    exit;
    
} catch (Exception $e) {
    error_log('Volvo Callback Error: ' . $e->getMessage());
    
    // Session invalidieren
    unset($_SESSION['volvo_access'], $_SESSION['volvo_refresh'], $_SESSION['volvo_exp']);
    
    // Weiterleitung zur Login-Seite mit Fehler
    header('Location: /login.php?volvo_error=' . urlencode($e->getMessage()));
    exit;
}

