<?php
/**
 * Profil aktualisieren
 */

session_start();

// Error reporting für Debugging
error_reporting(E_ALL);
ini_set('display_errors', 0);
ini_set('log_errors', 1);

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

// Prüfe ob User eingeloggt ist
if (!isset($_SESSION['user_logged_in']) || !$_SESSION['user_logged_in']) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Nicht autorisiert']);
    exit;
}

require_once __DIR__ . '/../config/database.php';

try {
    $db = new Database();
    $conn = $db->getConnection();
    $user_id = $_SESSION['user_id'];
    
    // Felder die aktualisiert werden können
    $allowed_fields = ['first_name', 'last_name', 'phone_number', 'address', 'postal_code', 'city'];
    $update_fields = [];
    $update_values = [];
    
    // Formdaten verarbeiten
    foreach ($allowed_fields as $field) {
        if (isset($_POST[$field])) {
            $update_fields[] = "$field = ?";
            $update_values[] = $_POST[$field];
        }
    }
    
    // Autohaus-ID verarbeiten (wird als preferred_dealership_id gespeichert)
    if (isset($_POST['autohaus_id'])) {
        $autohaus_id = !empty($_POST['autohaus_id']) ? intval($_POST['autohaus_id']) : null;
        
        // Prüfen ob die Autohaus-ID existiert und aktiv ist (falls angegeben)
        if ($autohaus_id !== null) {
            $stmt = $conn->prepare("SELECT id FROM autohaus WHERE id = ? AND is_active = 1");
            $stmt->execute([$autohaus_id]);
            if (!$stmt->fetch()) {
                // Autohaus-ID existiert nicht oder ist nicht aktiv, setze auf NULL
                $autohaus_id = null;
            }
        }
        
        $update_fields[] = "preferred_dealership_id = ?";
        $update_values[] = $autohaus_id;
    }
    
    // Profilbild verarbeiten
    if (isset($_FILES['profile_image']) && $_FILES['profile_image']['error'] === UPLOAD_ERR_OK) {
        $uploadDir = '../uploads/profile_images/';
        if (!is_dir($uploadDir)) {
            mkdir($uploadDir, 0755, true);
        }
        
        $fileExtension = pathinfo($_FILES['profile_image']['name'], PATHINFO_EXTENSION);
        $fileName = 'user_' . $user_id . '_' . time() . '.' . $fileExtension;
        $uploadFile = $uploadDir . $fileName;
        
        if (move_uploaded_file($_FILES['profile_image']['tmp_name'], $uploadFile)) {
            $update_fields[] = "profile_image = ?";
            $update_values[] = 'uploads/profile_images/' . $fileName;
        }
    }
    
    if (empty($update_fields)) {
        throw new Exception('Keine Felder zum Aktualisieren');
    }
    
    // Aktualisierungs-Zeit hinzufügen
    $update_fields[] = "updated_at = NOW()";
    
    // User-ID hinzufügen für WHERE-Klausel
    $update_values[] = $user_id;
    
    $sql = "UPDATE users SET " . implode(", ", $update_fields) . " WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $result = $stmt->execute($update_values);
    
    if ($result) {
        echo json_encode([
            'success' => true,
            'message' => 'Profil erfolgreich aktualisiert'
        ]);
    } else {
        throw new Exception('Fehler beim Aktualisieren');
    }
    
} catch (\Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?>
