<?php
/**
 * Trigger für Puppeteer-Import
 */

header('Content-Type: application/json');

require_once dirname(__DIR__) . '/config/database.php';
require_once __DIR__ . '/resy_puppeteer.php';

try {
    $input = json_decode(file_get_contents('php://input'), true);
    $autohausId = $input['autohaus_id'] ?? 1;
    
    error_log("Trigger Puppeteer - Autohaus ID: $autohausId");
    
    $db = new Database();
    $pdo = $db->getConnection();
    
    // Lade Autohaus-Daten
    $stmt = $pdo->prepare("SELECT id, name, resy_username, resy_password FROM autohaus WHERE id = ?");
    $stmt->execute([$autohausId]);
    $autohaus = $stmt->fetch(PDO::FETCH_ASSOC);
    
    error_log("Autohaus gefunden: " . ($autohaus['name'] ?? 'NICHT GEFUNDEN'));
    
    if (!$autohaus || !$autohaus['resy_username']) {
        throw new Exception("Keine RESY-Credentials gefunden");
    }
    
    error_log("Username: " . $autohaus['resy_username']);
    
    // Mapping
    $mapping = [
        'B & E Volvo Kiel' => '453',
        'B & E Volvo Norderstedt' => '452',
        'B & E Volvo Glinde' => '454'
    ];
    $dealerId = $mapping[$autohaus['name']] ?? '453';
    
    error_log("Dealer ID: $dealerId");
    
    // Puppeteer-Login
    $driver = new ResyPuppeteerDriver($autohaus['resy_username'], $autohaus['resy_password'], $dealerId);
    $wheelsets = $driver->loginAndFetch();
    
    error_log("Wheelsets gefunden: " . count($wheelsets));
    
    echo json_encode([
        'success' => true,
        'count' => count($wheelsets),
        'wheelsets' => $wheelsets,
        'debug' => [
            'autohaus' => $autohaus['name'],
            'username' => $autohaus['resy_username'],
            'dealer_id' => $dealerId
        ]
    ]);
    
} catch (Exception $e) {
    error_log("ERROR: " . $e->getMessage());
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}

