<?php
/**
 * RESY Reifen-Stornierung API
 */

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

require_once dirname(__DIR__) . '/config/database.php';

class TireCancellationService {
    private $baseUrl = 'https://resy.dtm-reifen.de';
    private $username = 'D.ULUDAG';
    private $password = 'Ikizler123!';
    private $dealerId = '113 B & E / Kiel';
    
    public function cancelTireOrder($storageNumber, $appointmentDate, $eventName) {
        try {
            // Schritt 1: Login
            $loginResult = $this->login();
            if (!$loginResult['success']) {
                return $loginResult;
            }
            
            // Schritt 2: Zur Bestellseite navigieren
            $searchResult = $this->navigateToOrderPage();
            if (!$searchResult['success']) {
                return $searchResult;
            }
            
            // Schritt 3: Satznummer suchen
            $searchTireResult = $this->searchTireSet($storageNumber);
            if (!$searchTireResult['success']) {
                return [
                    'success' => false,
                    'error' => 'Einlagerungsnummer ' . $storageNumber . ' nicht im RESY-System gefunden. Stornierung nicht möglich.'
                ];
            }
            
            // Schritt 4: Stornierung durchführen
            $cancelResult = $this->cancelOrder($storageNumber, $appointmentDate, $eventName, $searchTireResult['lgs_id']);
            if (!$cancelResult['success']) {
                return [
                    'success' => false,
                    'error' => 'Stornierung fehlgeschlagen: ' . $cancelResult['error']
                ];
            }
            
            return [
                'success' => true,
                'message' => 'Reifenbestellung erfolgreich storniert',
                'storage_number' => $storageNumber,
                'appointment_date' => $appointmentDate,
                'event_name' => $eventName,
                'cancelled_at' => date('Y-m-d H:i:s')
            ];
            
        } catch (Exception $e) {
            return [
                'success' => false,
                'error' => 'Fehler bei der Stornierung: ' . $e->getMessage()
            ];
        }
    }
    
    private function login() {
        $ch = curl_init();
        
        // Login-Seite laden
        curl_setopt($ch, CURLOPT_URL, $this->baseUrl . '/index.php?m=login&a=login');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_COOKIEJAR, sys_get_temp_dir() . '/resy_cookies.txt');
        curl_setopt($ch, CURLOPT_COOKIEFILE, sys_get_temp_dir() . '/resy_cookies.txt');
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36',
            'Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8',
            'Accept-Language: de-DE,de;q=0.9,en;q=0.8',
            'Accept-Encoding: gzip, deflate, br',
            'Connection: keep-alive',
            'Upgrade-Insecure-Requests: 1'
        ]);
        
        $loginPage = curl_exec($ch);
        
        if (curl_error($ch)) {
            curl_close($ch);
            return ['success' => false, 'error' => 'Fehler beim Laden der Login-Seite: ' . curl_error($ch)];
        }
        
        // Login-Formular ausfüllen
        curl_setopt($ch, CURLOPT_URL, $this->baseUrl . '/index.php?m=login&a=login');
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query([
            'username' => $this->username,
            'password' => $this->password,
            'login' => 'Anmelden'
        ]));
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/x-www-form-urlencoded',
            'User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36',
            'Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8',
            'Accept-Language: de-DE,de;q=0.9,en;q=0.8',
            'Accept-Encoding: gzip, deflate, br',
            'Connection: keep-alive',
            'Upgrade-Insecure-Requests: 1',
            'Referer: ' . $this->baseUrl . '/index.php?m=login&a=login'
        ]);
        
        $loginResponse = curl_exec($ch);
        
        if (curl_error($ch)) {
            curl_close($ch);
            return ['success' => false, 'error' => 'Fehler beim Login: ' . curl_error($ch)];
        }
        
        // Prüfen ob Login erfolgreich war
        if (strpos($loginResponse, 'Anmeldung fehlgeschlagen') !== false || 
            strpos($loginResponse, 'Falsche Anmeldedaten') !== false) {
            curl_close($ch);
            return ['success' => false, 'error' => 'Login fehlgeschlagen: Falsche Anmeldedaten'];
        }
        
        curl_close($ch);
        return ['success' => true, 'message' => 'Login erfolgreich'];
    }
    
    private function navigateToOrderPage() {
        $ch = curl_init();
        
        // Zur Bestellseite navigieren
        curl_setopt($ch, CURLOPT_URL, $this->baseUrl . '/index.php?m=wheelset&a=search');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_COOKIEFILE, sys_get_temp_dir() . '/resy_cookies.txt');
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36',
            'Accept: text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8',
            'Accept-Language: de-DE,de;q=0.8',
            'Referer: ' . $this->baseUrl . '/index.php?m=login&a=login'
        ]);
        
        $response = curl_exec($ch);
        
        if (curl_error($ch)) {
            curl_close($ch);
            return ['success' => false, 'error' => 'Fehler beim Laden der Bestellseite: ' . curl_error($ch)];
        }
        
        curl_close($ch);
        return ['success' => true, 'message' => 'Bestellseite geladen'];
    }
    
    private function searchTireSet($storageNumber) {
        $ch = curl_init();
        
        // Satznummer suchen mit GET-Methode
        $searchUrl = $this->baseUrl . '/index.php?m=wheelset&a=search&LGS_ID=' . urlencode($storageNumber) . '&button=submit&FN=WheelsetSearch';
        
        curl_setopt($ch, CURLOPT_URL, $searchUrl);
        curl_setopt($ch, CURLOPT_POST, false);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_COOKIEFILE, sys_get_temp_dir() . '/resy_cookies.txt');
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36',
            'Accept: text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8',
            'Accept-Language: de-DE,de;q=0.8',
            'Referer: ' . $this->baseUrl . '/index.php?m=wheelset&a=search'
        ]);
        
        $response = curl_exec($ch);
        
        if (curl_error($ch)) {
            curl_close($ch);
            return ['success' => false, 'error' => 'Fehler bei der Suche: ' . curl_error($ch)];
        }
        
        // Debug: Speichere die Suchantwort
        file_put_contents(sys_get_temp_dir() . '/resy_cancel_search_response.html', $response);
        error_log("Debug: Stornierung - Suche nach Einlagerungsnummer " . $storageNumber . " - Antwort gespeichert");
        
        // Prüfen ob Satznummer gefunden wurde
        if (strpos($response, 'Keine Ergebnisse gefunden') !== false || 
            strpos($response, 'Nicht gefunden') !== false ||
            strpos($response, 'keine Treffer') !== false ||
            strpos($response, 'Keine Treffer') !== false ||
            strpos($response, 'Keine Sätze gefunden') !== false ||
            strpos($response, 'keine Sätze gefunden') !== false) {
            curl_close($ch);
            return ['success' => false, 'error' => 'Einlagerungsnummer ' . $storageNumber . ' nicht im RESY-System gefunden'];
        }
        
        // Zusätzliche Prüfung: Antwort muss eine gültige Satznummer-Tabelle enthalten
        if (strpos($response, 'LGS_ID=') === false && strpos($response, 'Satznummer') === false) {
            curl_close($ch);
            return ['success' => false, 'error' => 'Einlagerungsnummer ' . $storageNumber . ' nicht im RESY-System gefunden (keine gültige Antwort)'];
        }
        
        // LGS_ID aus der Antwort extrahieren
        $lgsId = null;
        
        if (preg_match('/LGS_ID=(\d+)/', $response, $matches)) {
            $lgsId = $matches[1];
            error_log("Debug: Stornierung - LGS_ID gefunden: " . $lgsId . " für Einlagerungsnummer " . $storageNumber);
        } else {
            error_log("Debug: Stornierung - Keine LGS_ID in Antwort gefunden für Einlagerungsnummer " . $storageNumber);
        }
        
        if (!$lgsId) {
            curl_close($ch);
            return ['success' => false, 'error' => 'Einlagerungsnummer ' . $storageNumber . ' nicht im RESY-System gefunden (keine LGS_ID in Antwort)'];
        }
        
        curl_close($ch);
        return ['success' => true, 'lgs_id' => $lgsId, 'message' => 'Satznummer gefunden'];
    }
    
    private function cancelOrder($storageNumber, $appointmentDate, $eventName, $lgsId) {
        $ch = curl_init();
        
        // Schritt 1: Zur Bestellübersicht navigieren
        $orderUrl = $this->baseUrl . '/index.php?m=wheelset&a=order_now&LGS_ID=' . $lgsId . '&FN=WheelsetResult';
        curl_setopt($ch, CURLOPT_URL, $orderUrl);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_COOKIEFILE, sys_get_temp_dir() . '/resy_cookies.txt');
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36',
            'Accept: text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8',
            'Accept-Language: de-DE,de;q=0.8',
            'Referer: ' . $this->baseUrl . '/index.php?m=wheelset&a=search'
        ]);
        
        $orderResponse = curl_exec($ch);
        
        if (curl_error($ch)) {
            curl_close($ch);
            return ['success' => false, 'error' => 'Fehler beim Laden der Bestellübersicht: ' . curl_error($ch)];
        }
        
        // Debug: Speichere die Bestellübersicht
        file_put_contents(sys_get_temp_dir() . '/resy_cancel_order_response.html', $orderResponse);
        
        // Prüfen ob Bestellung stornierbar ist
        if (strpos($orderResponse, 'ButtonDetailsCancelOrder') === false && 
            strpos($orderResponse, 'button_cancel') === false &&
            strpos($orderResponse, 'Bestellung stornieren') === false) {
            curl_close($ch);
            return ['success' => false, 'error' => 'Bestellung für Einlagerungsnummer ' . $storageNumber . ' ist nicht stornierbar oder bereits storniert'];
        }
        
        // Schritt 2: Stornierung durchführen
        // Suche nach dem Stornierungs-Button und führe die Stornierung durch
        if (strpos($orderResponse, 'ButtonDetailsCancelOrder') !== false) {
            // Methode 1: ButtonDetailsCancelOrder
            $cancelUrl = $this->baseUrl . '/index.php?m=wheelset&a=cancel_order&LGS_ID=' . $lgsId;
        } else {
            // Methode 2: button_cancel
            $cancelUrl = $this->baseUrl . '/index.php?m=wheelset&a=cancel&LGS_ID=' . $lgsId;
        }
        
        curl_setopt($ch, CURLOPT_URL, $cancelUrl);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query([
            'LGS_ID' => $lgsId,
            'confirm' => '1'
        ]));
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/x-www-form-urlencoded',
            'User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36',
            'Accept: text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8',
            'Accept-Language: de-DE,de;q=0.8',
            'Referer: ' . $orderUrl
        ]);
        
        $cancelResponse = curl_exec($ch);
        
        if (curl_error($ch)) {
            curl_close($ch);
            return ['success' => false, 'error' => 'Fehler bei der Stornierung: ' . curl_error($ch)];
        }
        
        // Debug: Speichere die Stornierungsantwort
        file_put_contents(sys_get_temp_dir() . '/resy_cancel_final_response.html', $cancelResponse);
        
        // Prüfen ob Stornierung erfolgreich war
        if (strpos($cancelResponse, 'Bestellung storniert') !== false ||
            strpos($cancelResponse, 'erfolgreich storniert') !== false ||
            strpos($cancelResponse, 'Stornierung erfolgreich') !== false) {
            
            curl_close($ch);
            return ['success' => true, 'message' => 'Bestellung erfolgreich storniert'];
        } else {
            curl_close($ch);
            return ['success' => false, 'error' => 'Stornierung fehlgeschlagen - unbekannte Antwort vom System'];
        }
    }
}

// API-Handler
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!$input || !isset($input['storage_number']) || !isset($input['appointment_date']) || !isset($input['event_name'])) {
        echo json_encode([
            'success' => false,
            'error' => 'Ungültige Anfrage. Erforderliche Parameter: storage_number, appointment_date, event_name'
        ]);
        exit;
    }
    
    $service = new TireCancellationService();
    $result = $service->cancelTireOrder(
        $input['storage_number'],
        $input['appointment_date'],
        $input['event_name']
    );
    
    echo json_encode($result);
} else {
    echo json_encode([
        'success' => false,
        'error' => 'Nur POST-Anfragen erlaubt'
    ]);
}
?>
