<?php
/**
 * EINFACHER E-Mail-Test
 * Zeigt genau, wo das Problem ist
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h1>📧 Einfacher E-Mail-Test</h1>";

try {
    require_once __DIR__ . '/config.php';
    
    // Lade Autohaus-Daten
    $stmt = $pdo->prepare("SELECT id, name, email_smtp_host, email_smtp_port, email_smtp_username, email_smtp_password, email_smtp_encryption, email_from_name FROM autohaus WHERE is_active = 1 AND email_smtp_host IS NOT NULL LIMIT 1");
    $stmt->execute();
    $autohaus = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$autohaus) {
        die("❌ Kein Autohaus mit SMTP-Daten gefunden!");
    }
    
    echo "<h2>SMTP-Daten:</h2>";
    echo "<ul>";
    echo "<li>Name: " . htmlspecialchars($autohaus['name']) . "</li>";
    echo "<li>Host: " . htmlspecialchars($autohaus['email_smtp_host']) . "</li>";
    echo "<li>Port: " . htmlspecialchars($autohaus['email_smtp_port']) . "</li>";
    echo "<li>Username: " . htmlspecialchars($autohaus['email_smtp_username']) . "</li>";
    echo "<li>Password: " . (strlen($autohaus['email_smtp_password']) > 0 ? '✅ GESETZT (' . strlen($autohaus['email_smtp_password']) . ' Zeichen)' : '❌ LEER') . "</li>";
    echo "<li>Encryption: " . htmlspecialchars($autohaus['email_smtp_encryption']) . "</li>";
    echo "</ul>";
    
    // PHPMailer laden
    $phpmailerPath = __DIR__ . '/phpmailer/PHPMailer.php';
    if (!file_exists($phpmailerPath)) {
        die("❌ PHPMailer.php nicht gefunden unter: $phpmailerPath");
    }
    
    echo "<h2>PHPMailer laden...</h2>";
    // Verwende vendor-Version (richtige PHPMailer-Implementierung)
    if (file_exists(__DIR__ . '/../vendor/phpmailer/PHPMailer.php')) {
        require_once __DIR__ . '/../vendor/phpmailer/PHPMailer.php';
        require_once __DIR__ . '/../vendor/phpmailer/SMTP.php';
        require_once __DIR__ . '/../vendor/phpmailer/Exception.php';
        echo "✅ Verwende vendor/PHPMailer (Original-Version)<br>";
    } else {
        require_once $phpmailerPath;
        require_once __DIR__ . '/phpmailer/SMTP.php';
        require_once __DIR__ . '/phpmailer/Exception.php';
        echo "✅ Verwende api/phpmailer (Custom-Version)<br>";
    }
    
    if (!class_exists('PHPMailer\\PHPMailer\\PHPMailer')) {
        die("❌ PHPMailer-Klasse konnte nicht geladen werden!");
    }
    
    // Prüfe welche Version geladen wurde
    $reflection = new ReflectionClass('PHPMailer\\PHPMailer\\PHPMailer');
    $filePath = $reflection->getFileName();
    $version = defined('PHPMailer\\PHPMailer\\PHPMailer::VERSION') ? PHPMailer\PHPMailer\PHPMailer::VERSION : 'unbekannt';
    
    echo "✅ PHPMailer geladen!<br>";
    echo "📄 Version: " . htmlspecialchars($version) . "<br>";
    echo "📁 Pfad: " . htmlspecialchars($filePath) . "<br><br>";
    
    // PHPMailer instanziieren
    $mail = new \PHPMailer\PHPMailer\PHPMailer(true);
    
    echo "<h2>SMTP konfigurieren...</h2>";
    $mail->isSMTP();
    $mail->Host = $autohaus['email_smtp_host'];
    $mail->SMTPAuth = true;
    $mail->Username = $autohaus['email_smtp_username'];
    $mail->Password = $autohaus['email_smtp_password'];
    
    // WICHTIG: TLS ERFORDERLICH für Office 365 auf Port 587!
    $mail->SMTPSecure = \PHPMailer\PHPMailer\PHPMailer::ENCRYPTION_STARTTLS;
    $mail->Port = 587;
    $mail->CharSet = 'UTF-8';
    $mail->SMTPDebug = 0;
    
    echo "✅ SMTP konfiguriert!<br><br>";
    
    // Test-E-Mail vorbereiten
    $testEmail = $_GET['email'] ?? $autohaus['email_smtp_username'];
    
    echo "<h2>E-Mail senden...</h2>";
    echo "<p>An: <strong>$testEmail</strong></p>";
    echo "<p>Betreff: <strong>Test E-Mail</strong></p>";
    
    $mail->setFrom($autohaus['email_smtp_username'], $autohaus['email_from_name'] ?? 'Boxenstop');
    $mail->addAddress($testEmail);
    $mail->Subject = 'Test E-Mail';
    $mail->Body = 'Dies ist eine Test-E-Mail.';
    $mail->isHTML(false);
    
    echo "<p>Versuche zu senden...</p>";
    
    // DETAILLIERTE Ausgabe vor Versand
    echo "<details style='background: #f9f9f9; padding: 15px; border-radius: 8px; margin: 10px 0;'>";
    echo "<summary style='cursor: pointer; font-weight: bold;'>📋 SMTP-Konfiguration Details</summary>";
    echo "<pre style='margin-top: 10px;'>";
    echo "Host: " . $mail->Host . "\n";
    echo "Port: " . $mail->Port . "\n";
    echo "SMTPAuth: " . ($mail->SMTPAuth ? 'TRUE' : 'FALSE') . "\n";
    echo "Username: " . $mail->Username . "\n";
    echo "Password Length: " . strlen($mail->Password) . " Zeichen\n";
    echo "SMTPSecure: " . var_export($mail->SMTPSecure, true) . "\n";
    echo "Hostname: " . ($mail->Hostname ?? 'NICHT GESETZT') . "\n";
    echo "</pre>";
    echo "</details>";
    
    // Aktiviere Debug für detaillierte Ausgabe
    ob_start();
    $mail->SMTPDebug = 2;
    $mail->Debugoutput = function($str, $level) {
        echo htmlspecialchars($str) . "<br>";
    };
    
    try {
        $result = $mail->send();
        $output = ob_get_clean();
        
        echo "<details style='background: #fff3cd; padding: 15px; border-radius: 8px; margin: 10px 0;'>";
        echo "<summary style='cursor: pointer; font-weight: bold;'>🔍 SMTP Debug Output</summary>";
        echo "<div style='margin-top: 10px; font-family: monospace; font-size: 0.9em;'>$output</div>";
        echo "</details>";
        
        if ($result) {
            echo "<h2 style='color: green;'>✅ ERFOLG! E-Mail wurde gesendet!</h2>";
            echo "<p>Bitte prüfen Sie Ihr Postfach: <strong>$testEmail</strong></p>";
        } else {
            echo "<h2 style='color: red;'>❌ FEHLER: E-Mail konnte nicht gesendet werden</h2>";
            echo "<p><strong>ErrorInfo:</strong> " . htmlspecialchars($mail->ErrorInfo) . "</p>";
            echo "<p><strong>Mögliche Ursachen:</strong></p>";
            echo "<ul>";
            echo "<li>Falsches SMTP-Passwort</li>";
            echo "<li>Account-Sperre durch zu viele Fehlversuche</li>";
            echo "<li>Firewall blockiert Port 587</li>";
            echo "<li>Office 365 erfordert App-Passwort</li>";
            echo "</ul>";
        }
    } catch (Exception $emailException) {
        $output = ob_get_clean();
        
        echo "<h2 style='color: red;'>❌ EXCEPTION BEIM SENDEN:</h2>";
        echo "<p><strong>Fehlermeldung:</strong> " . htmlspecialchars($emailException->getMessage()) . "</p>";
        echo "<p><strong>ErrorInfo:</strong> " . htmlspecialchars($mail->ErrorInfo) . "</p>";
        
        if ($output) {
            echo "<details style='background: #f5c6cb; padding: 15px; border-radius: 8px; margin: 10px 0;'>";
            echo "<summary style='cursor: pointer; font-weight: bold;'>🔍 SMTP Debug Output (MIT FEHLER)</summary>";
            echo "<div style='margin-top: 10px; font-family: monospace; font-size: 0.9em;'>$output</div>";
            echo "</details>";
        }
        
        echo "<details><summary style='cursor: pointer;'>Stack Trace</summary><pre>" . htmlspecialchars($emailException->getTraceAsString()) . "</pre></details>";
    }
    
} catch (Exception $e) {
    echo "<h2 style='color: red;'>❌ FEHLER:</h2>";
    echo "<p>" . htmlspecialchars($e->getMessage()) . "</p>";
    echo "<pre>" . htmlspecialchars($e->getTraceAsString()) . "</pre>";
}

?>

