<?php
/**
 * Email-Versand für Tire-Angebote
 */

function sendTireOfferEmail($offer, $autohaus, $recipientEmail, $token) {
    require_once dirname(__DIR__) . '/config/database.php';
    
    // Prüfe ob SMTP-Konfiguration vorhanden ist
    if (empty($autohaus['email_smtp_host']) || empty($autohaus['email_smtp_password'])) {
        return [
            'success' => false,
            'error' => 'SMTP-Konfiguration fehlt. Bitte konfigurieren Sie die SMTP-Einstellungen für das Autohaus in den Einstellungen.'
        ];
    }
    
    try {
        // PHPMailer laden - verwende gleiche Logik wie admin_approve_user.php
        if (file_exists(dirname(__DIR__) . '/vendor/phpmailer/PHPMailer.php')) {
            require_once dirname(__DIR__) . '/vendor/phpmailer/PHPMailer.php';
            require_once dirname(__DIR__) . '/vendor/phpmailer/SMTP.php';
            require_once dirname(__DIR__) . '/vendor/phpmailer/Exception.php';
        } else if (file_exists(dirname(__DIR__) . '/vendor/autoload.php')) {
            require_once dirname(__DIR__) . '/vendor/autoload.php';
        } else {
            require_once dirname(__DIR__) . '/api/phpmailer/PHPMailer.php';
            require_once dirname(__DIR__) . '/api/phpmailer/SMTP.php';
            require_once dirname(__DIR__) . '/api/phpmailer/Exception.php';
        }
        
        // PHPMailer instanziieren
        $mail = new \PHPMailer\PHPMailer\PHPMailer(true);
        
        // SMTP-Konfiguration aus Autohaus-Daten
        $mail->isSMTP();
        $mail->Host = $autohaus['email_smtp_host'];
        $mail->SMTPAuth = true;
        $mail->Username = $autohaus['email_smtp_username'];
        $mail->Password = $autohaus['email_smtp_password'];
        $mail->SMTPSecure = \PHPMailer\PHPMailer\PHPMailer::ENCRYPTION_STARTTLS;
        $mail->Port = $autohaus['email_smtp_port'] ?? 587;
        $mail->CharSet = 'UTF-8';
        $mail->SMTPDebug = 0;
        
        // Recipients
        $mail->setFrom($autohaus['email_smtp_username'], $autohaus['email_from_name'] ?? ($autohaus['name'] ?? 'B&E Gruppe'));
        $mail->addAddress($recipientEmail);
        
        // Add reply-to header
        $mail->addReplyTo($autohaus['email_smtp_username'], $autohaus['email_from_name'] ?? ($autohaus['name'] ?? 'B&E Gruppe'));
        
        // Content
        $mail->isHTML(true);
        $mail->Subject = 'Reifenangebot - ' . ($offer['license_plate'] ?? 'Ihr Fahrzeug');
        $mail->Body = generateTireOfferEmailBody($offer, $autohaus, $token);
        
        // Send email
        $mail->send();
        
        error_log("=== TIRE OFFER E-MAIL ERFOLGREICH ===");
        error_log("Empfänger: $recipientEmail");
        error_log("Autohaus: " . ($autohaus['name'] ?? 'Unbekannt'));
        error_log("SMTP Server: " . $autohaus['email_smtp_host'] . ":" . ($autohaus['email_smtp_port'] ?? 587));
        
        return [
            'success' => true,
            'message' => 'E-Mail erfolgreich versendet'
        ];
        
    } catch (\Exception $e) {
        error_log("=== TIRE OFFER E-MAIL FEHLER ===");
        error_log("Empfänger: $recipientEmail");
        error_log("Autohaus: " . ($autohaus['name'] ?? 'Unbekannt'));
        error_log("Fehler: " . $e->getMessage());
        error_log("SMTP Server: " . ($autohaus['email_smtp_host'] ?? 'NICHT GESETZT') . ":" . ($autohaus['email_smtp_port'] ?? 587));
        error_log("Username: " . ($autohaus['email_smtp_username'] ?? 'NICHT GESETZT'));
        
        return [
            'success' => false,
            'error' => 'E-Mail konnte nicht versendet werden: ' . $e->getMessage()
        ];
    }
}

function generateTireOfferEmailBody($offer, $autohaus, $token) {
    try {
        $baseUrl = getBaseUrl();
        $selectionUrl = $baseUrl . '/tire_offer_selection.php?token=' . $token;
        
        $offerData = json_decode($offer['offer_data'], true);
        if (json_last_error() !== JSON_ERROR_NONE) {
            error_log("JSON Parse Fehler in generateTireOfferEmailBody: " . json_last_error_msg());
            $offerData = [];
        }
        $newTires = $offerData['new_tires'] ?? [];
        $selectedServices = $offerData['selected_services'] ?? [];
        
        // Bereite Reifenliste vor
        $tiresList = '';
        if (!empty($newTires)) {
            foreach ($newTires as $tire) {
                $tiresList .= '<tr><td style="padding: 8px 0; border-bottom: 1px solid #e9ecef;">' . 
                             htmlspecialchars($tire['brand_model'] ?? '') . 
                             ' (' . htmlspecialchars($tire['dimension'] ?? '') . ')</td>' .
                             '<td style="padding: 8px 0; border-bottom: 1px solid #e9ecef; text-align: right; font-weight: 600;">' . 
                             number_format($tire['total'] ?? 0, 2, ',', '.') . ' €</td></tr>';
            }
        }
        
        // Bereite Services-Liste vor
        $servicesList = '';
        if (!empty($selectedServices)) {
            try {
                require_once dirname(__DIR__) . '/config/database.php';
                $db = new Database();
                $conn = $db->getConnection();
                
                foreach ($selectedServices as $serviceId) {
                    $stmt = $conn->prepare("SELECT name, price FROM autohaus_services WHERE id = ? AND autohaus_id = ?");
                    $stmt->execute([$serviceId, $offer['autohaus_id']]);
                    $service = $stmt->fetch(PDO::FETCH_ASSOC);
                    if ($service) {
                        $servicesList .= '<tr><td style="padding: 8px 0; border-bottom: 1px solid #e9ecef;">' . 
                                       htmlspecialchars($service['name']) . 
                                       '</td><td style="padding: 8px 0; border-bottom: 1px solid #e9ecef; text-align: right; font-weight: 600;">' . 
                                       number_format($service['price'], 2, ',', '.') . ' €</td></tr>';
                    }
                }
            } catch (Exception $e) {
                error_log("Fehler beim Laden der Services: " . $e->getMessage());
                $servicesList = '';
            }
        }
    } catch (Exception $e) {
        error_log("Fehler in generateTireOfferEmailBody: " . $e->getMessage());
        $servicesList = '';
        $tiresList = '';
    }
    
    // Brieftext einfügen
    $letterContent = $offer['letter_content'] ?? '';
    
    // E-Mail-Client-kompatible HTML mit Tabellen-Layout und Inline-CSS
    return '
    <!DOCTYPE html>
    <html lang="de">
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Reifenangebot</title>
    </head>
    <body style="margin: 0; padding: 0; background-color: #f5f5f5; font-family: Arial, Helvetica, sans-serif; font-size: 16px; line-height: 1.6; color: #333333;">
        <table width="100%" cellpadding="0" cellspacing="0" border="0" style="background-color: #f5f5f5; padding: 20px;">
            <tr>
                <td align="center">
                    <table width="600" cellpadding="0" cellspacing="0" border="0" style="max-width: 600px; background-color: #ffffff; border-radius: 8px; overflow: hidden; box-shadow: 0 2px 4px rgba(0,0,0,0.1);">
                        <!-- Header -->
                        <tr>
                            <td style="background-color: #667eea; padding: 40px 30px; text-align: center;">
                                <table width="100%" cellpadding="0" cellspacing="0" border="0">
                                    <tr>
                                        <td style="text-align: center; color: #ffffff; font-size: 32px; font-weight: bold; padding-bottom: 10px;">
                                            Reifenangebot
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="text-align: center; color: #ffffff; font-size: 14px; padding-top: 5px;">
                                            Professioneller Service für Ihr Fahrzeug
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                        
                        <!-- Content -->
                        <tr>
                            <td style="padding: 30px;">
                                ' . (!empty($letterContent) ? '<p style="margin: 0 0 20px 0; color: #333333; font-size: 16px; white-space: pre-wrap;">' . nl2br(htmlspecialchars($letterContent)) . '</p>' : '
                                <p style="margin: 0 0 20px 0; color: #333333; font-size: 16px;">
                                    <strong>Sehr geehrte Damen und Herren,</strong>
                                </p>
                                
                                <p style="margin: 0 0 20px 0; color: #333333; font-size: 16px;">
                                    anbei erhalten Sie Ihr Reifenangebot für Ihr Fahrzeug.
                                </p>
                                ') . '
                                
                                <!-- Preis-Hinweis -->
                                <table width="100%" cellpadding="0" cellspacing="0" border="0" style="background-color: #fff3cd; border: 2px solid #ffc107; border-radius: 6px; margin: 20px 0;">
                                    <tr>
                                        <td style="padding: 15px;">
                                            <p style="margin: 0; color: #856404; font-size: 14px; font-weight: bold;">
                                                WICHTIGER HINWEIS ZUM PREIS:
                                            </p>
                                            <p style="margin: 10px 0 0 0; color: #856404; font-size: 13px; line-height: 1.5;">
                                                Die angegebenen Reifenpreise gelten für 2 Wochen ab Angebotsdatum. Der Endpreis kann je nach Marktpreisen variieren. Zusätzliche Arbeiten können weitere Kosten verursachen.
                                            </p>
                                        </td>
                                    </tr>
                                </table>
                                
                                <!-- Angebots-Info -->
                                <table width="100%" cellpadding="0" cellspacing="0" border="0" style="background-color: #f8f9fa; border-left: 4px solid #667eea; border-radius: 4px; margin: 20px 0;">
                                    <tr>
                                        <td style="padding: 20px;">
                                            <p style="margin: 0 0 10px 0; color: #333333; font-size: 16px; font-weight: bold;">
                                                Ihr Reifenangebot
                                            </p>
                                            <p style="margin: 0; color: #666666; font-size: 14px;">
                                                ' . ($offer['license_plate'] ? 'Kennzeichen: <strong>' . htmlspecialchars($offer['license_plate']) . '</strong><br>' : '') . '
                                                ' . ($offer['auftrag_nr'] ? 'Auftragsnummer: <strong>' . htmlspecialchars($offer['auftrag_nr']) . '</strong><br>' : '') . '
                                                ' . ($offer['customer_name'] ? 'Kunde: <strong>' . htmlspecialchars($offer['customer_name'] . ' ' . ($offer['customer_firstname'] ?? '')) . '</strong>' : '') . '
                                            </p>
                                        </td>
                                    </tr>
                                </table>
                                
                                ' . (!empty($tiresList) ? '
                                <!-- Reifen-Liste -->
                                <table width="100%" cellpadding="0" cellspacing="0" border="0" style="margin: 20px 0;">
                                    <tr>
                                        <td style="padding-bottom: 10px;">
                                            <p style="margin: 0; color: #333333; font-size: 16px; font-weight: bold;">
                                                Empfohlene Reifen:
                                            </p>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <table width="100%" cellpadding="0" cellspacing="0" border="0" style="background-color: #f8f9fa; border-radius: 4px;">
                                                ' . $tiresList . '
                                            </table>
                                        </td>
                                    </tr>
                                </table>
                                ' : '') . '
                                
                                ' . (!empty($servicesList) ? '
                                <!-- Services-Liste -->
                                <table width="100%" cellpadding="0" cellspacing="0" border="0" style="margin: 20px 0;">
                                    <tr>
                                        <td style="padding-bottom: 10px;">
                                            <p style="margin: 0; color: #333333; font-size: 16px; font-weight: bold;">
                                                Zusatzleistungen:
                                            </p>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <table width="100%" cellpadding="0" cellspacing="0" border="0" style="background-color: #f8f9fa; border-radius: 4px;">
                                                ' . $servicesList . '
                                            </table>
                                        </td>
                                    </tr>
                                </table>
                                ' : '') . '
                                
                                ' . ($offer['total_amount'] ? '
                                <!-- Gesamtbetrag -->
                                <table width="100%" cellpadding="0" cellspacing="0" border="0" style="margin: 20px 0;">
                                    <tr>
                                        <td style="padding: 15px; background-color: #f8f9fa; border-radius: 4px; text-align: right;">
                                            <p style="margin: 0; color: #333333; font-size: 18px; font-weight: bold;">
                                                Gesamtbetrag: <span style="color: #667eea;">' . number_format($offer['total_amount'], 2, ',', '.') . ' €</span>
                                            </p>
                                        </td>
                                    </tr>
                                </table>
                                ' : '') . '
                                
                                <!-- Anweisungen -->
                                <table width="100%" cellpadding="0" cellspacing="0" border="0" style="margin: 30px 0;">
                                    <tr>
                                        <td style="padding-bottom: 15px;">
                                            <p style="margin: 0; color: #333333; font-size: 18px; font-weight: bold;">
                                                Kundenauswahl
                                            </p>
                                            <p style="margin: 10px 0 0 0; color: #666666; font-size: 14px;">
                                                Bitte wählen Sie aus den folgenden Optionen aus:
                                            </p>
                                        </td>
                                    </tr>
                                </table>
                                
                                <!-- CTA Button -->
                                <table width="100%" cellpadding="0" cellspacing="0" border="0" style="margin: 30px 0;">
                                    <tr>
                                        <td align="center" style="padding: 20px 0;">
                                            <table cellpadding="0" cellspacing="0" border="0">
                                                <tr>
                                                    <td style="background-color: #667eea; border-radius: 6px; padding: 16px 32px;">
                                                        <a href="' . htmlspecialchars($selectionUrl) . '" style="color: #ffffff; text-decoration: none; font-size: 16px; font-weight: bold; display: inline-block;">
                                                            Auswahl treffen
                                                        </a>
                                                    </td>
                                                </tr>
                                            </table>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td align="center" style="padding: 10px 0;">
                                            <p style="margin: 0; color: #666666; font-size: 13px;">
                                                Falls der Button nicht angezeigt wird, kopieren Sie bitte diesen Link:<br>
                                                <a href="' . htmlspecialchars($selectionUrl) . '" style="color: #667eea; text-decoration: underline; word-break: break-all;">' . htmlspecialchars($selectionUrl) . '</a>
                                            </p>
                                        </td>
                                    </tr>
                                </table>
                                
                                <!-- Link-Hinweis -->
                                <table width="100%" cellpadding="0" cellspacing="0" border="0" style="background-color: #fff3cd; border: 1px solid #ffc107; border-radius: 4px; margin: 20px 0;">
                                    <tr>
                                        <td style="padding: 15px;">
                                            <p style="margin: 0; color: #856404; font-size: 14px; font-weight: bold;">
                                                Wichtiger Hinweis:
                                            </p>
                                            <p style="margin: 10px 0 0 0; color: #856404; font-size: 13px; line-height: 1.5;">
                                                Der Link ist 24 Stunden gültig. Ihre Auswahl wird automatisch an uns übermittelt und Sie erhalten eine Bestätigung.
                                            </p>
                                        </td>
                                    </tr>
                                </table>
                                
                                <p style="margin: 20px 0 0 0; color: #333333; font-size: 16px;">
                                    Bei Fragen stehen wir Ihnen gerne zur Verfügung.
                                </p>
                            </td>
                        </tr>
                        
                        <!-- Footer -->
                        <tr>
                            <td style="background-color: #f8f9fa; padding: 30px; text-align: center; border-top: 1px solid #dee2e6;">
                                <p style="margin: 0 0 10px 0; color: #333333; font-size: 16px; font-weight: bold;">
                                    Mit freundlichen Grüßen
                                </p>
                                <p style="margin: 0 0 5px 0; color: #667eea; font-size: 18px; font-weight: bold;">
                                    ' . htmlspecialchars($offer['employee_name'] ?? ($autohaus['email_from_name'] ?? $autohaus['name'])) . '
                                </p>
                                <p style="margin: 0; color: #333333; font-size: 14px;">
                                    ' . htmlspecialchars($autohaus['name']) . '
                                </p>
                                <p style="margin: 20px 0 0 0; color: #999999; font-size: 12px; line-height: 1.5;">
                                    Diese E-Mail wurde automatisch generiert. Bitte antworten Sie nicht direkt auf diese E-Mail.
                                </p>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
    </body>
    </html>';
}

function getBaseUrl() {
    $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https://' : 'http://';
    $host = $_SERVER['HTTP_HOST'] ?? 'localhost';
    $scriptName = dirname($_SERVER['SCRIPT_NAME'] ?? '');
    
    // Wenn wir in api/ sind, gehen wir eine Ebene höher
    if (strpos($scriptName, '/api') !== false) {
        $scriptName = dirname($scriptName);
    }
    
    return $protocol . $host . $scriptName;
}
