<?php
/**
 * Speichert eine Push-Subscription für einen Benutzer
 */

session_start();
header('Content-Type: application/json');

// Prüfe ob User eingeloggt ist
if (!isset($_SESSION['user_logged_in']) || !$_SESSION['user_logged_in']) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Nicht autorisiert']);
    exit;
}

require_once __DIR__ . '/../config/database.php';

try {
    $db = new Database();
    $conn = $db->getConnection();
    
    // Prüfe ob push_subscriptions Tabelle existiert, sonst erstelle sie
    $stmt = $conn->query("SHOW TABLES LIKE 'push_subscriptions'");
    if ($stmt->rowCount() === 0) {
        // Tabelle erstellen
        $createTableSQL = "
        CREATE TABLE push_subscriptions (
            id INT AUTO_INCREMENT PRIMARY KEY,
            user_id INT NOT NULL,
            endpoint VARCHAR(500) NOT NULL,
            p256dh VARCHAR(200) NOT NULL,
            auth VARCHAR(50) NOT NULL,
            user_agent TEXT,
            device_info TEXT,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            is_active TINYINT(1) DEFAULT 1,
            UNIQUE KEY unique_endpoint (endpoint),
            KEY idx_user_id (user_id),
            KEY idx_is_active (is_active),
            FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
        ";
        $conn->exec($createTableSQL);
    }
    
    $user_id = $_SESSION['user_id'];
    $data = json_decode(file_get_contents('php://input'), true);
    
    if (!isset($data['subscription']) || !isset($data['subscription']['endpoint'])) {
        throw new Exception('Ungültige Subscription-Daten');
    }
    
    $subscription = $data['subscription'];
    $endpoint = $subscription['endpoint'];
    $keys = $subscription['keys'];
    
    if (!isset($keys['p256dh']) || !isset($keys['auth'])) {
        throw new Exception('Ungültige Subscription-Keys');
    }
    
    $p256dh = $keys['p256dh'];
    $auth = $keys['auth'];
    $user_agent = $_SERVER['HTTP_USER_AGENT'] ?? '';
    $device_info = json_encode([
        'platform' => $_SERVER['HTTP_SEC_CH_UA_PLATFORM'] ?? 'unknown',
        'user_agent' => $user_agent
    ]);
    
    // Prüfe welche Spaltennamen existieren (p256dh/auth oder p256dh_key/auth_key)
    $stmt = $conn->query("DESCRIBE push_subscriptions");
    $columns = $stmt->fetchAll(PDO::FETCH_COLUMN);
    
    $useNewNames = in_array('p256dh', $columns) && in_array('auth', $columns);
    $p256dhColumn = $useNewNames ? 'p256dh' : 'p256dh_key';
    $authColumn = $useNewNames ? 'auth' : 'auth_key';
    
    // Prüfe ob Subscription bereits existiert
    $stmt = $conn->prepare("SELECT id, user_id FROM push_subscriptions WHERE endpoint = ?");
    $stmt->execute([$endpoint]);
    $existing = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($existing) {
        // Update bestehende Subscription
        $stmt = $conn->prepare("
            UPDATE push_subscriptions 
            SET user_id = ?, $p256dhColumn = ?, $authColumn = ?, user_agent = ?, device_info = ?, is_active = 1, updated_at = NOW()
            WHERE endpoint = ?
        ");
        $stmt->execute([$user_id, $p256dh, $auth, $user_agent, $device_info, $endpoint]);
    } else {
        // Neue Subscription erstellen
        $stmt = $conn->prepare("
            INSERT INTO push_subscriptions (user_id, endpoint, $p256dhColumn, $authColumn, user_agent, device_info, is_active)
            VALUES (?, ?, ?, ?, ?, ?, 1)
        ");
        $stmt->execute([$user_id, $endpoint, $p256dh, $auth, $user_agent, $device_info]);
    }
    
    echo json_encode([
        'success' => true,
        'message' => 'Subscription erfolgreich gespeichert'
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?>

