<?php
/**
 * Entfernt eine Push-Subscription
 */

session_start();
header('Content-Type: application/json');

// Prüfe ob User eingeloggt ist
if (!isset($_SESSION['user_logged_in']) || !$_SESSION['user_logged_in']) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Nicht autorisiert']);
    exit;
}

require_once __DIR__ . '/../config/database.php';

try {
    $db = new Database();
    $conn = $db->getConnection();
    
    $user_id = $_SESSION['user_id'];
    $data = json_decode(file_get_contents('php://input'), true);
    
    if (!isset($data['endpoint'])) {
        throw new Exception('Endpoint fehlt');
    }
    
    $endpoint = $data['endpoint'];
    
    // Entferne Subscription (nur wenn sie dem User gehört)
    $stmt = $conn->prepare("DELETE FROM push_subscriptions WHERE endpoint = ? AND user_id = ?");
    $stmt->execute([$endpoint, $user_id]);
    
    echo json_encode([
        'success' => true,
        'message' => 'Subscription erfolgreich entfernt'
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?>

