<?php
/**
 * Link a customer account to an admin account
 */

session_start();
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

// Nur für eingeloggte Admins
if (!isset($_SESSION['admin_logged_in']) || !$_SESSION['admin_logged_in']) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Nicht autorisiert']);
    exit;
}

require_once __DIR__ . '/../config/database.php';

try {
    $input = json_decode(file_get_contents('php://input'), true);
    
    $user_id = $input['user_id'] ?? null;
    $admin_user_id = $input['admin_user_id'] ?? null;
    
    if (!$user_id || !$admin_user_id) {
        throw new Exception('User ID und Admin User ID sind erforderlich');
    }
    
    // Validiere dass beide IDs existieren
    $db = new Database();
    $conn = $db->getConnection();
    
    // Prüfe ob User existiert
    $stmt = $conn->prepare("SELECT id FROM users WHERE id = ?");
    $stmt->execute([$user_id]);
    if (!$stmt->fetch()) {
        throw new Exception('User nicht gefunden');
    }
    
    // Prüfe ob Admin User existiert
    $stmt = $conn->prepare("SELECT id FROM admin_users WHERE id = ? AND is_active = 1");
    $stmt->execute([$admin_user_id]);
    if (!$stmt->fetch()) {
        throw new Exception('Admin User nicht gefunden oder nicht aktiv');
    }
    
    // Verknüpfe User mit Admin
    $stmt = $conn->prepare("UPDATE users SET admin_user_id = ? WHERE id = ?");
    $stmt->execute([$admin_user_id, $user_id]);
    
    echo json_encode([
        'success' => true,
        'message' => 'User erfolgreich mit Admin verknüpft'
    ]);
    
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
?>

