<?php
// Public API root for boxenstop/api — minimal and safe.
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');
header('Content-Type: application/json; charset=utf-8');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(204);
    exit;
}

$endpoints = [
    '/api/get_offer_details.php' => 'Get offer details (GET/POST)',
    '/api/get_customer_selection.php' => 'Customer selection helper',
    '/api/resy_data_extraction.php' => 'RESY integration entrypoint',
    '/api/generate_pdf_tcpdf.php' => 'Generate PDFs (TCPDF)',
];

if (is_readable(__DIR__ . '/.dev_allow_file_list')) {
    $scan = [];
    foreach (glob(__DIR__ . '/*.php') as $f) {
        $scan['/api/' . basename($f)] = 'auto-detected';
    }
    $endpoints = array_merge($endpoints, $scan);
}

echo json_encode([
    'name' => 'Boxenstop API (boxenstop)',
    'message' => 'Use specific endpoints for app communication. See admin docs for auth details.',
    'endpoints' => $endpoints,
], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);

exit;
