<?php
/**
 * Gibt den VAPID Public Key für Push-Benachrichtigungen zurück
 */

header('Content-Type: application/json');

// VAPID Keys (müssen generiert werden - siehe Anleitung)
// Für Produktion: Diese Keys sollten in einer Konfigurationsdatei gespeichert werden
$vapidKeys = [
    'publicKey' => 'BEl62iUYgUivxIkv69yViEuiBIa40HIgFyYhqVt8WiTVxKk8KMWfOmuBOtwUpSUR7g2mrszQjNI-rQyX7ZXsKY0',
    'privateKey' => 'private_key_here' // Wird nur auf dem Server verwendet
];

// Für Produktion: Keys aus Datenbank oder Konfigurationsdatei laden
require_once __DIR__ . '/../config/database.php';

try {
    $db = new Database();
    $conn = $db->getConnection();
    
    // Prüfe ob VAPID Keys in der Datenbank gespeichert sind
    $stmt = $conn->prepare("SELECT setting_value FROM settings WHERE setting_key = 'vapid_public_key'");
    $stmt->execute();
    $publicKey = $stmt->fetchColumn();
    
    if ($publicKey) {
        $vapidKeys['publicKey'] = $publicKey;
    } else {
        // Erstelle Standard-Keys (für Entwicklung)
        // WICHTIG: Für Produktion müssen echte VAPID Keys generiert werden!
        // Siehe: https://web-push-codelab.glitch.me/
    }
} catch (Exception $e) {
    // Fallback auf Standard-Keys
}

echo json_encode([
    'success' => true,
    'publicKey' => $vapidKeys['publicKey']
]);
?>

