<?php
/**
 * Direkter RESY-Import OHNE Browser
 * Nutzt cURL mit korrekten Headers
 */

header('Content-Type: application/json');
require_once dirname(__DIR__) . '/config/database.php';

$autohausId = $_GET['autohaus_id'] ?? 1;

$db = new Database();
$pdo = $db->getConnection();

// Lade Credentials
$stmt = $pdo->prepare("SELECT name, resy_username, resy_password FROM autohaus WHERE id = ?");
$stmt->execute([$autohausId]);
$autohaus = $stmt->fetch(PDO::FETCH_ASSOC);

$mapping = [
    'B & E Volvo Kiel' => '453',
    'B & E Volvo Norderstedt' => '452',
    'B & E Volvo Glinde' => '454'
];
$dealerId = $mapping[$autohaus['name'] ?? ''] ?? '453';

// 1. Cookie-Jar erstellen
$cookieFile = sys_get_temp_dir() . '/resy_' . uniqid() . '.txt';

// 2. Login
$loginUrl = 'https://resy.dtm-reifen.de/index.php?m=login&a=login';

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $loginUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
curl_setopt($ch, CURLOPT_COOKIEJAR, $cookieFile);
curl_setopt($ch, CURLOPT_COOKIEFILE, $cookieFile);
curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36');
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_HEADER, true);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($httpCode === 200) {
    // 3. Submit Login
    $postData = http_build_query([
        'FN' => 'login',
        'UserName' => $autohaus['resy_username'],
        'Password' => $autohaus['resy_password'],
        'button' => 'submit'
    ]);
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $loginUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, false);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
    curl_setopt($ch, CURLOPT_COOKIEJAR, $cookieFile);
    curl_setopt($ch, CURLOPT_COOKIEFILE, $cookieFile);
    curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36');
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    
    curl_exec($ch);
    curl_close($ch);
    
    // 4. Hole Reifensätze
    $searchUrl = "https://resy.dtm-reifen.de/index.php?m=wheelset&a=search&FN=WheelsetSearch&KD_ID=$dealerId&STATUS_ID=20";
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $searchUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_COOKIEFILE, $cookieFile);
    curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36');
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    
    $html = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    @unlink($cookieFile);
    
    if ($httpCode === 200 && $html) {
        // Parse HTML
        libxml_use_internal_errors(true);
        $dom = new DOMDocument();
        $dom->loadHTML($html);
        $xpath = new DOMXPath($dom);
        
        $rows = $xpath->query('//tr');
        $wheelsets = [];
        
        foreach ($rows as $row) {
            $cells = $xpath->query('./td', $row);
            
            if ($cells->length >= 2) {
                $kennzeichen = trim($cells->item(0)->textContent ?? '');
                
                if (strlen($kennzeichen) >= 2 && strlen($kennzeichen) <= 20) {
                    $wheelsets[] = [
                        'kennzeichen' => $kennzeichen,
                        'satznummer' => trim($cells->item(1)->textContent ?? ''),
                        'marke' => 'RESY',
                        'modell' => '',
                        'oe_nummer' => ''
                    ];
                }
            }
        }
        
        // Speichere in DB
        foreach ($wheelsets as $ws) {
            $stmt = $pdo->prepare("
                INSERT INTO stored_wheelsets 
                (autohaus_id, kennzeichen, marke, modell, oe_nummer, status, updated_at)
                VALUES (?, ?, ?, ?, ?, 'gelagert', NOW())
                ON DUPLICATE KEY UPDATE updated_at = NOW()
            ");
            $stmt->execute([
                $autohausId,
                $ws['kennzeichen'],
                $ws['marke'],
                $ws['modell'],
                $ws['oe_nummer']
            ]);
        }
        
        echo json_encode([
            'success' => true,
            'count' => count($wheelsets),
            'wheelsets' => $wheelsets,
            'source' => 'resy'
        ]);
    } else {
        echo json_encode([
            'success' => false,
            'error' => 'Keine Daten von RESY',
            'count' => 0,
            'wheelsets' => []
        ]);
    }
} else {
    echo json_encode([
        'success' => false,
        'error' => 'RESY nicht erreichbar',
        'count' => 0,
        'wheelsets' => []
    ]);
}

