<?php
/**
 * Automatischer RESY-Datenabruf mit Session-Management
 */

header('Content-Type: application/json');
require_once dirname(__DIR__) . '/config/database.php';
require_once __DIR__ . '/resy_session_manager.php';

$autohausId = $_GET['autohaus_id'] ?? 1;

// Load autohaus
$db = new Database();
$pdo = $db->getConnection();
$GLOBALS['pdo'] = $pdo;

$stmt = $pdo->prepare("SELECT name, resy_username, resy_password FROM autohaus WHERE id = ?");
$stmt->execute([$autohausId]);
$autohaus = $stmt->fetch(PDO::FETCH_ASSOC);

$mapping = [
    'B & E Volvo Kiel' => '453',
    'B & E Volvo Norderstedt' => '452',
    'B & E Volvo Glinde' => '454'
];
$dealerId = $mapping[$autohaus['name'] ?? ''] ?? '453';

// Hole Reifensätze mit Session-Manager
$sessionMgr = new ResySessionManager();
$searchUrl = "https://resy.dtm-reifen.de/index.php?m=wheelset&a=search&FN=WheelsetSearch&KD_ID=$dealerId&STATUS_ID=20";

$html = $sessionMgr->makeRequest($searchUrl);

if ($html && strlen($html) > 1000) {
    // Parse HTML
    libxml_use_internal_errors(true);
    $dom = new DOMDocument();
    $dom->loadHTML($html);
    $xpath = new DOMXPath($dom);
    
    $rows = $xpath->query('//tr');
    $wheelsets = [];
    
    foreach ($rows as $row) {
        $cells = $xpath->query('./td', $row);
        
        if ($cells->length >= 2) {
            $kennzeichen = trim($cells->item(0)->textContent ?? '');
            
            if (strlen($kennzeichen) >= 2 && strlen($kennzeichen) <= 20) {
                $wheelsets[] = [
                    'kennzeichen' => $kennzeichen,
                    'satznummer' => trim($cells->item(1)->textContent ?? ''),
                    'marke' => 'RESY',
                    'modell' => '',
                    'oe_nummer' => ''
                ];
            }
        }
    }
    
    // Speichere in DB
    foreach ($wheelsets as $ws) {
        $stmt = $pdo->prepare("
            INSERT INTO stored_wheelsets 
            (autohaus_id, kennzeichen, marke, modell, oe_nummer, status, updated_at)
            VALUES (?, ?, ?, ?, ?, 'gelagert', NOW())
            ON DUPLICATE KEY UPDATE updated_at = NOW()
        ");
        $stmt->execute([
            $autohausId,
            $ws['kennzeichen'],
            $ws['marke'],
            $ws['modell'],
            $ws['oe_nummer']
        ]);
    }
    
    echo json_encode([
        'success' => true,
        'count' => count($wheelsets),
        'wheelsets' => $wheelsets,
        'source' => 'resy',
        'message' => count($wheelsets) . ' Reifensätze von RESY geladen'
    ]);
} else {
    echo json_encode([
        'success' => false,
        'error' => 'Keine HTML-Daten von RESY erhalten',
        'count' => 0,
        'wheelsets' => []
    ]);
}

