<?php
/**
 * E-Mail Diagnose
 * Zeigt alle Probleme bei E-Mail-Versand
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h1>🔍 E-Mail-Diagnose</h1>";

require_once __DIR__ . '/config.php';

// 1. PHPMailer prüfen
echo "<h2>1. PHPMailer Status</h2>";
if (class_exists('PHPMailer\\PHPMailer\\PHPMailer')) {
    echo "✅ PHPMailer verfügbar<br>";
} else {
    echo "❌ PHPMailer nicht verfügbar<br>";
    echo "Prüfe Dateien:<br>";
    $files = ['phpmailer/PHPMailer.php', 'phpmailer/SMTP.php', 'phpmailer/Exception.php'];
    foreach ($files as $file) {
        $path = __DIR__ . '/' . $file;
        echo file_exists($path) ? "✅ $file<br>" : "❌ $file (NICHT GEFUNDEN)<br>";
    }
}

// 2. Autohaus SMTP-Daten prüfen
echo "<h2>2. Autohaus SMTP-Daten</h2>";
$stmt = $pdo->prepare("SELECT id, name, email_smtp_host, email_smtp_port, email_smtp_username, 
                              COALESCE(CHAR_LENGTH(email_smtp_password), 0) as password_length,
                              email_smtp_encryption, email_from_name, is_active
                      FROM autohaus 
                      WHERE is_active = 1 
                      ORDER BY id");
$stmt->execute();
$autohauses = $stmt->fetchAll(PDO::FETCH_ASSOC);

if (empty($autohauses)) {
    echo "❌ Keine aktiven Autohäuser gefunden<br>";
} else {
    echo "<table border='1' cellpadding='5' style='border-collapse: collapse;'>";
    echo "<tr><th>ID</th><th>Name</th><th>Host</th><th>Port</th><th>Username</th><th>Password</th><th>Encryption</th></tr>";
    foreach ($autohauses as $ah) {
        echo "<tr>";
        echo "<td>" . htmlspecialchars($ah['id']) . "</td>";
        echo "<td>" . htmlspecialchars($ah['name']) . "</td>";
        echo "<td>" . htmlspecialchars($ah['email_smtp_host'] ?: 'NICHT GESETZT') . "</td>";
        echo "<td>" . htmlspecialchars($ah['email_smtp_port'] ?: 'NICHT GESETZT') . "</td>";
        echo "<td>" . htmlspecialchars($ah['email_smtp_username'] ?: 'NICHT GESETZT') . "</td>";
        echo "<td>" . ($ah['password_length'] > 0 ? '✅ GESETZT (' . $ah['password_length'] . ' Zeichen)' : '❌ NICHT GESETZT') . "</td>";
        echo "<td>" . htmlspecialchars($ah['email_smtp_encryption'] ?: 'NICHT GESETZT') . "</td>";
        echo "</tr>";
    }
    echo "</table>";
}

// 3. Test-SMTP-Verbindung
echo "<h2>3. Test SMTP-Verbindung</h2>";

if (!empty($autohauses)) {
    $autohaus = $autohauses[0];
    
    if (!empty($autohaus['email_smtp_host']) && !empty($autohaus['email_smtp_username']) && $autohaus['password_length'] > 0) {
        echo "Teste Verbindung zu: " . htmlspecialchars($autohaus['email_smtp_host']) . ":" . htmlspecialchars($autohaus['email_smtp_port']) . "<br><br>";
        
        if (class_exists('PHPMailer\\PHPMailer\\PHPMailer') || !class_exists('PHPMailer\\PHPMailer\\PHPMailer')) {
            // Verwende vendor-Version (richtige PHPMailer-Implementierung mit Office 365 Fix)
            if (file_exists(__DIR__ . '/../vendor/phpmailer/PHPMailer.php')) {
                require_once __DIR__ . '/../vendor/phpmailer/PHPMailer.php';
                require_once __DIR__ . '/../vendor/phpmailer/SMTP.php';
                require_once __DIR__ . '/../vendor/phpmailer/Exception.php';
            } else {
                require_once __DIR__ . '/phpmailer/PHPMailer.php';
                require_once __DIR__ . '/phpmailer/SMTP.php';
                require_once __DIR__ . '/phpmailer/Exception.php';
            }
            
            try {
                $mail = new \PHPMailer\PHPMailer\PHPMailer(true);
                
                // Konfiguration
                $mail->isSMTP();
                $mail->Host = $autohaus['email_smtp_host'];
                $mail->SMTPAuth = true;
                $mail->Username = $autohaus['email_smtp_username'];
                $mail->Password = $autohaus['email_smtp_password']; // WICHTIG: Werte aus Query holen!
                
                // Hole Passwort neu aus DB
                $stmt2 = $pdo->prepare("SELECT email_smtp_password FROM autohaus WHERE id = ?");
                $stmt2->execute([$autohaus['id']]);
                $passResult = $stmt2->fetch(PDO::FETCH_ASSOC);
                if ($passResult) {
                    $mail->Password = $passResult['email_smtp_password'];
                }
                
                $mail->SMTPSecure = 'tls';
                $mail->Port = 587;
                $mail->CharSet = 'UTF-8';
                $mail->SMTPDebug = 2;
                
                // Test-E-Mail
                $mail->setFrom($autohaus['email_smtp_username'], 'Test');
                $mail->addAddress($autohaus['email_smtp_username'], 'Test');
                $mail->Subject = 'Test E-Mail';
                $mail->Body = 'Dies ist eine Test-E-Mail vom Diagnose-System.';
                
                ob_start();
                $result = $mail->send();
                $output = ob_get_clean();
                
                echo "<pre style='background: #f5f5f5; padding: 10px; border: 1px solid #ddd; max-height: 400px; overflow-y: auto;'>";
                echo htmlspecialchars($output);
                echo "</pre>";
                
                if ($result) {
                    echo "<p style='color: green;'>✅ E-Mail erfolgreich versendet!</p>";
                } else {
                    echo "<p style='color: red;'>❌ E-Mail konnte nicht versendet werden</p>";
                }
                
            } catch (Exception $e) {
                echo "<p style='color: red;'>❌ FEHLER: " . htmlspecialchars($e->getMessage()) . "</p>";
                echo "<pre>" . htmlspecialchars($e->getTraceAsString()) . "</pre>";
            }
        } else {
            echo "PHPMailer nicht verfügbar";
        }
    } else {
        echo "❌ SMTP-Konfiguration unvollständig";
    }
} else {
    echo "Keine Autohäuser zum Testen";
}

// 4. Settings Tabelle prüfen
echo "<h2>4. Settings Tabelle</h2>";
$stmt = $pdo->prepare("SELECT setting_key, setting_value FROM settings WHERE setting_key LIKE 'smtp_%'");
$stmt->execute();
$settings = $stmt->fetchAll(PDO::FETCH_ASSOC);

if (empty($settings)) {
    echo "❌ Keine SMTP-Einstellungen in settings Tabelle<br>";
} else {
    echo "<ul>";
    foreach ($settings as $setting) {
        $value = htmlspecialchars($setting['setting_value']);
        if ($setting['setting_key'] === 'smtp_password') {
            $value = str_repeat('*', strlen($setting['setting_value']));
        }
        echo "<li><strong>" . htmlspecialchars($setting['setting_key']) . ":</strong> $value</li>";
    }
    echo "</ul>";
}

?>

