<?php
/**
 * Prüft ob eine Push-Subscription existiert
 */

session_start();
header('Content-Type: application/json');

// Prüfe ob User eingeloggt ist
if (!isset($_SESSION['user_logged_in']) || !$_SESSION['user_logged_in']) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Nicht autorisiert']);
    exit;
}

require_once __DIR__ . '/../config/database.php';

try {
    $db = new Database();
    $conn = $db->getConnection();
    
    $data = json_decode(file_get_contents('php://input'), true);
    
    if (!isset($data['endpoint'])) {
        throw new Exception('Endpoint fehlt');
    }
    
    $endpoint = $data['endpoint'];
    
    // Prüfe ob Subscription existiert
    $stmt = $conn->prepare("SELECT id FROM push_subscriptions WHERE endpoint = ? AND is_active = 1");
    $stmt->execute([$endpoint]);
    $exists = $stmt->fetch() !== false;
    
    echo json_encode([
        'success' => true,
        'exists' => $exists
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?>

