<?php
// Output-Buffer früh starten, damit Response-Größe geloggt werden kann
if (!headers_sent()) { @ob_start(); }

// Hilfsfunktionen
function api_get_header($name) {
  $k = 'HTTP_' . strtoupper(str_replace('-', '_', $name));
  return $_SERVER[$k] ?? null;
}

function api_json($code, $payload) {
  http_response_code($code);
  header('Content-Type: application/json; charset=utf-8');
  echo json_encode($payload, JSON_UNESCAPED_UNICODE);
}

function api_deny($code, $message) {
  api_json($code, ['success' => false, 'message' => $message]);
  exit;
}

function api_cors() {
  $allowed = [
    'https://be-automobileapps.de',
    'https://www.be-automobileapps.de',
    'http://localhost',
    'http://127.0.0.1'
  ];
  $origin = $_SERVER['HTTP_ORIGIN'] ?? '';
  if ($origin && in_array($origin, $allowed, true)) {
    header('Access-Control-Allow-Origin: ' . $origin);
  }
  header('Vary: Origin');
  header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
  header('Access-Control-Allow-Headers: Content-Type, X-Api-Key, X-Timestamp, X-Nonce, X-Signature');
  header('Access-Control-Max-Age: 600');
  if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(204);
    exit;
  }
}

// Haupt-Guard laden und ausführen (wird auf Dateiebene ausgeführt)
require_once __DIR__ . '/_guard.php';
