<?php
// Analysiere die Login-Antwort
$htmlFile = sys_get_temp_dir() . '/resy_login_response_1.html';

echo "<h1>Login Response Analyse</h1>";

if (file_exists($htmlFile)) {
    $html = file_get_contents($htmlFile);
    echo "<p>HTML-Datei gefunden: " . strlen($html) . " bytes</p>";
    
    // Prüfe auf Login-Formular
    $hasAnmeldename = strpos($html, 'Anmeldename') !== false;
    $hasKennwort = strpos($html, 'Kennwort') !== false;
    $hasAnmeldung = strpos($html, 'Anmeldung') !== false;
    
    echo "<h2>Login-Formular Erkennung:</h2>";
    echo "<p>Anmeldename gefunden: " . ($hasAnmeldename ? "✅ JA" : "❌ NEIN") . "</p>";
    echo "<p>Kennwort gefunden: " . ($hasKennwort ? "✅ JA" : "❌ NEIN") . "</p>";
    echo "<p>Anmeldung gefunden: " . ($hasAnmeldung ? "✅ JA" : "❌ NEIN") . "</p>";
    
    $hasLoginForm = $hasAnmeldename || $hasKennwort || $hasAnmeldung;
    echo "<p><strong>Login-Formular erkannt: " . ($hasLoginForm ? "✅ JA" : "❌ NEIN") . "</strong></p>";
    
    // Prüfe auf Erfolgs-Indikatoren
    $hasLagerbestand = strpos($html, 'Lagerbestand') !== false;
    $hasResyWebsystem = strpos($html, 'RESY Websystem') !== false;
    $hasUbersicht = strpos($html, 'Übersicht') !== false;
    $hasDashboard = strpos($html, 'dashboard') !== false;
    
    echo "<h2>Erfolgs-Indikatoren:</h2>";
    echo "<p>Lagerbestand gefunden: " . ($hasLagerbestand ? "✅ JA" : "❌ NEIN") . "</p>";
    echo "<p>RESY Websystem gefunden: " . ($hasResyWebsystem ? "✅ JA" : "❌ NEIN") . "</p>";
    echo "<p>Übersicht gefunden: " . ($hasUbersicht ? "✅ JA" : "❌ NEIN") . "</p>";
    echo "<p>dashboard gefunden: " . ($hasDashboard ? "✅ JA" : "❌ NEIN") . "</p>";
    
    $hasSuccessIndicators = $hasLagerbestand || $hasResyWebsystem || $hasUbersicht || $hasDashboard;
    echo "<p><strong>Erfolgs-Indikatoren gefunden: " . ($hasSuccessIndicators ? "✅ JA" : "❌ NEIN") . "</strong></p>";
    
    // Login-Ergebnis
    $loginSuccessful = !$hasLoginForm && $hasSuccessIndicators;
    echo "<h2>Login-Ergebnis:</h2>";
    echo "<p><strong>Login erfolgreich: " . ($loginSuccessful ? "✅ JA" : "❌ NEIN") . "</strong></p>";
    
    // Zeige ersten Teil der HTML
    echo "<h2>HTML-Content (erste 2000 Zeichen):</h2>";
    echo "<pre>" . htmlspecialchars(substr($html, 0, 2000)) . "</pre>";
    
} else {
    echo "<p style='color: red;'>HTML-Datei nicht gefunden: $htmlFile</p>";
}
?>
