<?php
/**
 * Prüft, ob "labelprinter service" korrekt verbunden ist
 */

require_once __DIR__ . '/../config/printer.php';

echo "✅ Drucker-Verbindung prüfen\n";
echo str_repeat("=", 60) . "\n\n";

$printer_name_local = 'LABELPRINTER SERVICE';
$server_ip = PRINTER_SERVER_TAILSCALE_IP;

// 1. Prüfe, ob Drucker installiert ist
echo "1. Prüfe, ob Drucker installiert ist...\n";
$check_cmd = sprintf(
    'powershell -NoProfile -ExecutionPolicy Bypass -Command "try { $p = Get-Printer -Name \'%s\' -ErrorAction Stop; Write-Host \"✅ Drucker gefunden: $($p.Name)\"; Write-Host \"Status: $($p.PrinterStatus)\"; Write-Host \"Port: $($p.PortName)\"; Write-Host \"Driver: $($p.DriverName)\" } catch { Write-Host \"❌ Drucker nicht gefunden: $_\" }" 2>&1',
    str_replace("'", "''", $printer_name_local)
);
exec($check_cmd, $check_output, $check_code);
$printer_found = false;
foreach ($check_output as $line) {
    echo "   $line\n";
    if (stripos($line, '✅') !== false || stripos($line, 'Drucker gefunden') !== false) {
        $printer_found = true;
    }
}
echo "\n";

if (!$printer_found) {
    echo "❌❌❌ DRUCKER NICHT GEFUNDEN!\n\n";
    echo "Bitte führen Sie zuerst aus:\n";
    echo "  php admin/connect_labelprinter_service.php\n\n";
    exit(1);
}

// 2. Prüfe Port-Status
echo "2. Prüfe Port-Status...\n";
$port_check_cmd = sprintf(
    'powershell -NoProfile -ExecutionPolicy Bypass -Command "try { $p = Get-Printer -Name \'%s\'; $port = $p.PortName; if ($port -like \'\\\\*\' -or $port -like \'*%s*\') { Write-Host \"✅ Port korrekt: $port\" } else { Write-Host \"⚠️ Port: $port\" } } catch { }" 2>&1',
    str_replace("'", "''", $printer_name_local),
    $server_ip
);
exec($port_check_cmd, $port_check_output, $port_check_code);
foreach ($port_check_output as $line) {
    echo "   $line\n";
}
echo "\n";

// 3. Test-Druck
echo "3. Test-Druck...\n";
$test_file = sys_get_temp_dir() . '\\test_labelprinter_' . date('His') . '.txt';
file_put_contents($test_file, "TEST DRUCK\n" . date('Y-m-d H:i:s') . "\nlabelprinter service\n");

$test_cmd = sprintf('print /D:"%s" "%s" 2>&1', $printer_name_local, $test_file);
exec($test_cmd, $test_output, $test_code);
$test_text = implode("\n", $test_output);
if (function_exists('mb_convert_encoding')) {
    $test_text = @mb_convert_encoding($test_text, 'UTF-8', 'Windows-1252');
}

echo "   Return Code: $test_code\n";
echo "   Ausgabe: $test_text\n";

$port_init_error = (stripos($test_text, 'konnte nicht initialisiert werden') !== false);

if ($port_init_error) {
    echo "   ❌ Port kann nicht initialisiert werden!\n\n";
    echo "   Problem: Die Authentifizierung wurde nicht korrekt gespeichert.\n\n";
    echo "   Lösung:\n";
    echo "   1. Öffne Windows Explorer → \\\\$server_ip\n";
    echo "   2. Rechtsklick auf 'labelprinter service'\n";
    echo "   3. Falls bereits verbunden: 'Drucker entfernen'\n";
    echo "   4. Dann erneut: 'Drucker verbinden'\n";
    echo "   5. WICHTIG: Bei Credentials-Abfrage 'Anmeldedaten speichern' aktivieren\n";
} else {
    echo "   ✅ Test-Druck erfolgreich!\n\n";
    
    // Prüfe Warteschlange
    echo "4. Prüfe Warteschlange...\n";
    sleep(2);
    $queue_cmd = sprintf(
        'powershell -NoProfile -ExecutionPolicy Bypass -Command "try { $jobs = Get-PrintJob -PrinterName \'%s\' -ErrorAction SilentlyContinue | Sort-Object SubmittedTime -Descending | Select-Object -First 1; if ($jobs) { Write-Host \"✅ Auftrag in Warteschlange: ID $($jobs.Id), Status: $($jobs.JobStatus)\" } else { Write-Host \"⚠️ Keine Aufträge in Warteschlange (kann normal sein, wenn sofort gedruckt wurde)\" } } catch { }" 2>&1',
        str_replace("'", "''", $printer_name_local)
    );
    exec($queue_cmd, $queue_output, $queue_code);
    foreach ($queue_output as $line) {
        echo "   $line\n";
    }
}

@unlink($test_file);

echo "\n";
echo str_repeat("=", 60) . "\n";
echo "ZUSAMMENFASSUNG\n";
echo str_repeat("=", 60) . "\n\n";

if ($port_init_error) {
    echo "❌ DRUCKER INSTALLIERT, ABER PORT KANN NICHT INITIALISIERT WERDEN\n\n";
    echo "Der Drucker ist installiert, aber die Authentifizierung wurde nicht\n";
    echo "korrekt gespeichert. Bitte verbinden Sie den Drucker erneut über\n";
    echo "Windows Explorer und aktivieren Sie 'Anmeldedaten speichern'.\n";
} else {
    echo "✅✅✅ DRUCKER FUNKTIONIERT!\n\n";
    echo "Der Drucker ist korrekt installiert und kann drucken.\n";
    echo "Die API sollte jetzt auch funktionieren.\n";
}









