<?php
/**
 * Migration: WhatsApp Template-Konfigurationen Tabelle erstellen
 */

require_once __DIR__ . '/../config/database.php';

$db = new Database();
$conn = $db->getConnection();

try {
    $sql = "
    CREATE TABLE IF NOT EXISTS whatsapp_template_configs (
        id INT AUTO_INCREMENT PRIMARY KEY,
        autohaus_id INT NOT NULL,
        action_type VARCHAR(50) NOT NULL COMMENT 'Aktion: reminder_24h, reminder_48h, confirmation, cancellation, rescheduled, etc.',
        template_id VARCHAR(100) NOT NULL COMMENT 'HelloMateo Template-ID',
        send_timing VARCHAR(50) DEFAULT NULL COMMENT 'Timing: immediate, 24h_before, 48h_before, etc.',
        send_timing_hours INT DEFAULT NULL COMMENT 'Stunden vor/nach Termin (z.B. -24 für 24h vorher, 0 für sofort)',
        is_active TINYINT(1) DEFAULT 1 COMMENT 'Aktiv/Inaktiv',
        custom_fields_mapping TEXT DEFAULT NULL COMMENT 'JSON: Mapping von Template-Platzhaltern zu Datenbankfeldern',
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        
        UNIQUE KEY unique_autohaus_action (autohaus_id, action_type),
        INDEX idx_autohaus_id (autohaus_id),
        INDEX idx_action_type (action_type),
        INDEX idx_is_active (is_active),
        
        FOREIGN KEY (autohaus_id) REFERENCES autohaus(id) ON DELETE CASCADE
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci
    COMMENT='Konfigurationen für WhatsApp-Templates pro Autohaus und Aktion';
    ";
    
    $conn->exec($sql);
    echo "✅ Tabelle 'whatsapp_template_configs' erfolgreich erstellt!\n";
    
} catch (Exception $e) {
    if (strpos($e->getMessage(), 'already exists') !== false) {
        echo "ℹ️ Tabelle 'whatsapp_template_configs' existiert bereits.\n";
    } else {
        echo "❌ Fehler: " . $e->getMessage() . "\n";
    }
}





