-- Migration: WhatsApp Template-Konfigurationen Tabelle
-- Datum: 2025-12-10
-- Beschreibung: Erstellt Tabelle für Template-Konfigurationen pro Autohaus und Aktion

CREATE TABLE IF NOT EXISTS whatsapp_template_configs (
    id INT AUTO_INCREMENT PRIMARY KEY,
    autohaus_id INT NOT NULL,
    action_type VARCHAR(50) NOT NULL COMMENT 'Aktion: reminder_24h, reminder_48h, confirmation, cancellation, rescheduled, etc.',
    template_id VARCHAR(100) NOT NULL COMMENT 'HelloMateo Template-ID',
    send_timing VARCHAR(50) DEFAULT NULL COMMENT 'Timing: immediate, 24h_before, 48h_before, etc.',
    send_timing_hours INT DEFAULT NULL COMMENT 'Stunden vor/nach Termin (z.B. -24 für 24h vorher, 0 für sofort)',
    is_active TINYINT(1) DEFAULT 1 COMMENT 'Aktiv/Inaktiv',
    custom_fields_mapping TEXT DEFAULT NULL COMMENT 'JSON: Mapping von Template-Platzhaltern zu Datenbankfeldern',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    
    UNIQUE KEY unique_autohaus_action (autohaus_id, action_type),
    INDEX idx_autohaus_id (autohaus_id),
    INDEX idx_action_type (action_type),
    INDEX idx_is_active (is_active),
    
    FOREIGN KEY (autohaus_id) REFERENCES autohaus(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci
COMMENT='Konfigurationen für WhatsApp-Templates pro Autohaus und Aktion';

-- Beispiel-Daten für reminder_24h
-- INSERT INTO whatsapp_template_configs (autohaus_id, action_type, template_id, send_timing, send_timing_hours, custom_fields_mapping) 
-- VALUES (1, 'reminder_24h', '692772f9-6841-41d0-a174-55b3145be4fa', '24h_before', -24, '{"custom_fields.last_name": "customer_name_last", "custom_fields.first_name": "customer_name_first"}');





