<?php
/**
 * Fix WhatsApp Logs Table - Fügt fehlende Spalten hinzu
 */

require_once __DIR__ . '/../config/database.php';

header('Content-Type: application/json');

try {
    $db = new Database();
    $conn = $db->getConnection();
    
    // Prüfe ob Tabelle existiert
    $tableCheck = $conn->query("SHOW TABLES LIKE 'whatsapp_logs'");
    
    if ($tableCheck->rowCount() === 0) {
        // Tabelle existiert nicht - erstelle sie komplett
        $conn->exec("
            CREATE TABLE whatsapp_logs (
                id INT AUTO_INCREMENT PRIMARY KEY,
                appointment_id INT,
                autohaus_id INT,
                phone_number VARCHAR(20),
                customer_name VARCHAR(255),
                action_type VARCHAR(50),
                status VARCHAR(20),
                message TEXT,
                error_message TEXT,
                created_at DATETIME,
                updated_at DATETIME,
                INDEX idx_appointment (appointment_id),
                INDEX idx_autohaus (autohaus_id),
                INDEX idx_status (status),
                INDEX idx_created (created_at)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4
        ");
        
        echo json_encode(['success' => true, 'message' => 'Tabelle whatsapp_logs wurde erstellt']);
    } else {
        // Tabelle existiert - füge fehlende Spalten hinzu
        $columns = $conn->query("SHOW COLUMNS FROM whatsapp_logs")->fetchAll(PDO::FETCH_COLUMN);
        $added = [];
        
        if (!in_array('customer_name', $columns)) {
            $conn->exec("ALTER TABLE whatsapp_logs ADD COLUMN customer_name VARCHAR(255) AFTER phone_number");
            $added[] = 'customer_name';
        }
        if (!in_array('action_type', $columns)) {
            $conn->exec("ALTER TABLE whatsapp_logs ADD COLUMN action_type VARCHAR(50) AFTER customer_name");
            $added[] = 'action_type';
        }
        if (!in_array('status', $columns)) {
            $conn->exec("ALTER TABLE whatsapp_logs ADD COLUMN status VARCHAR(20) AFTER action_type");
            $added[] = 'status';
        }
        if (!in_array('message', $columns)) {
            $conn->exec("ALTER TABLE whatsapp_logs ADD COLUMN message TEXT AFTER status");
            $added[] = 'message';
        }
        if (!in_array('error_message', $columns)) {
            $conn->exec("ALTER TABLE whatsapp_logs ADD COLUMN error_message TEXT AFTER message");
            $added[] = 'error_message';
        }
        if (!in_array('updated_at', $columns)) {
            $conn->exec("ALTER TABLE whatsapp_logs ADD COLUMN updated_at DATETIME AFTER created_at");
            $added[] = 'updated_at';
        }
        
        if (empty($added)) {
            echo json_encode(['success' => true, 'message' => 'Tabelle ist bereits vollständig', 'columns' => $columns]);
        } else {
            echo json_encode(['success' => true, 'message' => 'Fehlende Spalten hinzugefügt', 'added' => $added]);
        }
    }
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}




