<?php
/**
 * Script zum Beheben von Drucker-Port-Problemen
 * Prüft und korrigiert Drucker-Status, Port-Konfiguration und Authentifizierung
 */

require_once __DIR__ . '/../config/printer.php';

echo "🔧 Drucker-Port-Reparatur\n";
echo str_repeat("=", 60) . "\n\n";

$printer_name = 'LABELPRINTER SERVICE';
$server_ip = PRINTER_SERVER_TAILSCALE_IP;
$server_user = PRINTER_SERVER_USER;
$server_pass = PRINTER_SERVER_PASS;

echo "Drucker: $printer_name\n";
echo "Server: $server_ip\n\n";

// 1. Prüfe aktuellen Drucker-Status
echo "1. Prüfe Drucker-Status...\n";
$status_cmd = sprintf(
    'powershell -NoProfile -ExecutionPolicy Bypass -Command "try { $p = Get-Printer -Name \'%s\' -ErrorAction Stop; Write-Host \"Status: $($p.PrinterStatus)\"; Write-Host \"WorkOffline: $($p.WorkOffline)\"; Write-Host \"Port: $($p.PortName)\"; Write-Host \"Driver: $($p.DriverName)\" } catch { Write-Host \"Fehler: $_\" }" 2>&1',
    str_replace("'", "''", $printer_name)
);
exec($status_cmd, $status_output, $status_code);
foreach ($status_output as $line) {
    echo "   $line\n";
}
echo "\n";

// 2. Prüfe Port-Status
echo "2. Prüfe Port-Status...\n";
$port_cmd = sprintf(
    'powershell -NoProfile -ExecutionPolicy Bypass -Command "try { $port = Get-PrinterPort -Name \'%s\' -ErrorAction Stop; Write-Host \"Port gefunden: $($port.Name)\"; Write-Host \"PrinterHostIP: $($port.PrinterHostIP)\" } catch { Write-Host \"Port nicht gefunden oder Fehler: $_\" }" 2>&1',
    "\\\\$server_ip\\$printer_name"
);
exec($port_cmd, $port_output, $port_code);
foreach ($port_output as $line) {
    echo "   $line\n";
}
echo "\n";

// 3. Stelle sicher, dass net use erfolgreich ist
echo "3. Prüfe net use Verbindung...\n";
$net_use_cmd = sprintf(
    'net use "\\\\%s" %s /user:%s 2>&1',
    $server_ip,
    $server_pass ? escapeshellarg($server_pass) : '',
    escapeshellarg($server_user)
);
exec($net_use_cmd, $net_use_output, $net_use_code);
foreach ($net_use_output as $line) {
    echo "   $line\n";
}
$net_use_success = ($net_use_code === 0);
echo "   " . ($net_use_success ? "✅ net use erfolgreich" : "❌ net use fehlgeschlagen") . "\n\n";

// 4. Setze Drucker online (falls offline)
echo "4. Setze Drucker online...\n";
$set_online_cmd = sprintf(
    'powershell -NoProfile -ExecutionPolicy Bypass -Command "try { Set-Printer -Name \'%s\' -WorkOffline $false -ErrorAction Stop; Write-Host \"Drucker online gesetzt\" } catch { Write-Host \"Fehler: $_\" }" 2>&1',
    str_replace("'", "''", $printer_name)
);
exec($set_online_cmd, $set_online_output, $set_online_code);
foreach ($set_online_output as $line) {
    echo "   $line\n";
}
echo "\n";

// 5. Prüfe, ob Port erreichbar ist
echo "5. Prüfe Port-Erreichbarkeit...\n";
$port_test_cmd = sprintf(
    'powershell -NoProfile -ExecutionPolicy Bypass -Command "try { Test-Path \'%s\' | Out-Null; if (Test-Path \'%s\') { Write-Host \"Port ist erreichbar\" } else { Write-Host \"Port ist NICHT erreichbar\" } } catch { Write-Host \"Fehler: $_\" }" 2>&1',
    "\\\\$server_ip\\$printer_name",
    "\\\\$server_ip\\$printer_name"
);
exec($port_test_cmd, $port_test_output, $port_test_code);
foreach ($port_test_output as $line) {
    echo "   $line\n";
}
echo "\n";

// 6. Versuche, Port neu zu konfigurieren
echo "6. Versuche Port neu zu konfigurieren...\n";
$port_name = "\\\\$server_ip\\$printer_name";

// Lösche alten Port (falls vorhanden)
$delete_port_cmd = sprintf(
    'powershell -NoProfile -ExecutionPolicy Bypass -Command "try { Remove-PrinterPort -Name \'%s\' -ErrorAction SilentlyContinue; Write-Host \"Alter Port gelöscht\" } catch { }" 2>&1',
    str_replace("'", "''", $port_name)
);
exec($delete_port_cmd, $delete_port_output, $delete_port_code);

// Erstelle neuen Port mit Authentifizierung
// WICHTIG: Für UNC-Ports müssen wir Add-PrinterPort mit ConnectionName verwenden
$create_port_cmd = sprintf(
    'powershell -NoProfile -ExecutionPolicy Bypass -Command "try { $port = Add-PrinterPort -Name \'%s\' -ErrorAction Stop; Write-Host \"Port erstellt\" } catch { Write-Host \"Port-Fehler: $_\" }" 2>&1',
    str_replace("'", "''", $port_name)
);
exec($create_port_cmd, $create_port_output, $create_port_code);
foreach ($create_port_output as $line) {
    echo "   $line\n";
}
echo "\n";

// 7. Setze Port für Drucker
echo "7. Setze Port für Drucker...\n";
$set_port_cmd = sprintf(
    'powershell -NoProfile -ExecutionPolicy Bypass -Command "try { Set-Printer -Name \'%s\' -PortName \'%s\' -ErrorAction Stop; Write-Host \"Port gesetzt\" } catch { Write-Host \"Fehler: $_\" }" 2>&1',
    str_replace("'", "''", $printer_name),
    str_replace("'", "''", $port_name)
);
exec($set_port_cmd, $set_port_output, $set_port_code);
foreach ($set_port_output as $line) {
    echo "   $line\n";
}
echo "\n";

// 8. Prüfe finalen Status
echo "8. Finaler Status-Check...\n";
exec($status_cmd, $final_status_output, $final_status_code);
foreach ($final_status_output as $line) {
    echo "   $line\n";
}
echo "\n";

// 9. Test-Druck
echo "9. Versuche Test-Druck...\n";
$test_file = sys_get_temp_dir() . '\\test_print.txt';
file_put_contents($test_file, "TEST DRUCK\n" . date('Y-m-d H:i:s') . "\n");

$test_print_cmd = sprintf(
    'print /D:"%s" "%s" 2>&1',
    $printer_name,
    $test_file
);
exec($test_print_cmd, $test_print_output, $test_print_code);
$test_print_text = implode("\n", $test_print_output);
echo "   Return Code: $test_print_code\n";
echo "   Ausgabe: $test_print_text\n";

if (stripos($test_print_text, 'konnte nicht initialisiert werden') !== false) {
    echo "   ❌ Drucker-Port kann immer noch nicht initialisiert werden!\n";
    echo "\n   💡 Mögliche Lösungen:\n";
    echo "   1. Drucker manuell über Windows Explorer verbinden:\n";
    echo "      - Öffne Windows Explorer\n";
    echo "      - Gebe ein: \\\\$server_ip\n";
    echo "      - Rechtsklick auf '$printer_name' → 'Drucker verbinden'\n";
    echo "      - Verwende Credentials: $server_user / [Passwort]\n";
    echo "\n   2. Drucker als Standard-Drucker setzen (bereits gemacht)\n";
    echo "\n   3. Drucker-Treiber neu installieren\n";
    echo "\n   4. Windows-Druckerdienst neu starten:\n";
    echo "      net stop spooler\n";
    echo "      net start spooler\n";
} else {
    echo "   ✅ Test-Druck erfolgreich!\n";
}

@unlink($test_file);

echo "\n" . str_repeat("=", 60) . "\n";
echo "Fertig!\n";









