<?php
/**
 * Behebt Drucker-Fehler und setzt Drucker online
 */

require_once __DIR__ . '/../config/printer.php';

echo "🔧 Drucker-Fehler beheben\n";
echo str_repeat("=", 60) . "\n\n";

$printer_name = 'LABELPRINTER SERVICE';
$server_ip = PRINTER_SERVER_TAILSCALE_IP;
$server_user = PRINTER_SERVER_USER;
$server_pass = PRINTER_SERVER_PASS;

// 1. Detaillierter Status-Check
echo "1. Detaillierter Drucker-Status...\n";
$status_cmd = sprintf(
    'powershell -NoProfile -ExecutionPolicy Bypass -Command "try { $p = Get-Printer -Name \'%s\' -ErrorAction Stop; Write-Host \"Name: $($p.Name)\"; Write-Host \"Status: $($p.PrinterStatus)\"; Write-Host \"Port: $($p.PortName)\"; Write-Host \"Driver: $($p.DriverName)\"; Write-Host \"Shared: $($p.Shared)\"; Write-Host \"Published: $($p.Published)\" } catch { Write-Host \"Fehler: $_\" }" 2>&1',
    str_replace("'", "''", $printer_name)
);
exec($status_cmd, $status_output, $status_code);
foreach ($status_output as $line) {
    echo "   $line\n";
}
echo "\n";

// 2. Prüfe Windows-Ereignisanzeige für Drucker-Fehler
echo "2. Prüfe Windows-Ereignisanzeige (letzte Drucker-Fehler)...\n";
$event_cmd = 'powershell -NoProfile -ExecutionPolicy Bypass -Command "Get-EventLog -LogName System -Source \"Print\" -Newest 3 -ErrorAction SilentlyContinue | Select-Object TimeGenerated, EntryType, Message | Format-List" 2>&1';
exec($event_cmd, $event_output, $event_code);
if (!empty($event_output)) {
    foreach ($event_output as $line) {
        if (trim($line)) {
            echo "   $line\n";
        }
    }
} else {
    echo "   Keine Ereignisse gefunden\n";
}
echo "\n";

// 3. Stelle net use Verbindung her
echo "3. Stelle net use Verbindung her...\n";
$net_use_cmd = sprintf(
    'net use "\\\\%s" %s /user:%s /persistent:yes 2>&1',
    $server_ip,
    $server_pass ? escapeshellarg($server_pass) : '',
    escapeshellarg($server_user)
);
exec($net_use_cmd, $net_use_output, $net_use_code);
foreach ($net_use_output as $line) {
    if (trim($line)) {
        echo "   $line\n";
    }
}
$net_use_success = ($net_use_code === 0);
echo "   " . ($net_use_success ? "✅ Erfolgreich" : "❌ Fehlgeschlagen") . "\n\n";

// 4. Versuche, Drucker online zu setzen
echo "4. Versuche, Drucker online zu setzen...\n";
$set_online_cmd = sprintf(
    'powershell -NoProfile -ExecutionPolicy Bypass -Command "try { $p = Get-Printer -Name \'%s\' -ErrorAction Stop; if ($p.PrinterStatus -eq \'Error\' -or $p.PrinterStatus -eq \'Offline\') { Write-Host \"Drucker hat Fehler-Status, versuche zu beheben...\"; Set-Printer -Name \'%s\' -ErrorAction Stop; Write-Host \"Drucker-Einstellungen aktualisiert\" } else { Write-Host \"Drucker-Status: $($p.PrinterStatus)\" } } catch { Write-Host \"Fehler: $_\" }" 2>&1',
    str_replace("'", "''", $printer_name),
    str_replace("'", "''", $printer_name)
);
exec($set_online_cmd, $set_online_output, $set_online_code);
foreach ($set_online_output as $line) {
    echo "   $line\n";
}
echo "\n";

// 5. Prüfe Port-Erreichbarkeit
echo "5. Prüfe Port-Erreichbarkeit...\n";
$port_name = "\\\\$server_ip\\LABELPRINTER SERVICE";
$port_test_cmd = sprintf(
    'powershell -NoProfile -ExecutionPolicy Bypass -Command "try { if (Test-Path \'%s\') { Write-Host \"✅ Port ist erreichbar\" } else { Write-Host \"❌ Port ist NICHT erreichbar\" } } catch { Write-Host \"Fehler: $_\" }" 2>&1',
    str_replace("'", "''", $port_name)
);
exec($port_test_cmd, $port_test_output, $port_test_code);
foreach ($port_test_output as $line) {
    echo "   $line\n";
}
echo "\n";

// 6. Versuche, Port neu zu konfigurieren
echo "6. Versuche, Port neu zu konfigurieren...\n";
$port_reconfig_cmd = sprintf(
    'powershell -NoProfile -ExecutionPolicy Bypass -Command "try { $p = Get-Printer -Name \'%s\'; $currentPort = $p.PortName; Write-Host \"Aktueller Port: $currentPort\"; Set-Printer -Name \'%s\' -PortName \'%s\' -ErrorAction Stop; Write-Host \"Port aktualisiert\" } catch { Write-Host \"Fehler: $_\" }" 2>&1',
    str_replace("'", "''", $printer_name),
    str_replace("'", "''", $printer_name),
    str_replace("'", "''", $port_name)
);
exec($port_reconfig_cmd, $port_reconfig_output, $port_reconfig_code);
foreach ($port_reconfig_output as $line) {
    echo "   $line\n";
}
echo "\n";

// 7. Starte Druckerdienst neu
echo "7. Starte Windows-Druckerdienst neu...\n";
echo "   Stoppe Dienst...\n";
exec('net stop spooler 2>&1', $stop_output, $stop_code);
sleep(2);
echo "   Starte Dienst...\n";
exec('net start spooler 2>&1', $start_output, $start_code);
foreach ($start_output as $line) {
    if (trim($line)) {
        echo "   $line\n";
    }
}
sleep(3);
echo "\n";

// 8. Finaler Status-Check
echo "8. Finaler Status-Check...\n";
exec($status_cmd, $final_status_output, $final_status_code);
foreach ($final_status_output as $line) {
    echo "   $line\n";
}
echo "\n";

// 9. Test-Druck
echo "9. Test-Druck...\n";
$test_file = sys_get_temp_dir() . '\\test_fix_' . date('His') . '.txt';
file_put_contents($test_file, "TEST NACH FEHLER-BEHEBUNG\n" . date('Y-m-d H:i:s') . "\n");

$test_cmd = sprintf('print /D:"%s" "%s" 2>&1', $printer_name, $test_file);
exec($test_cmd, $test_output, $test_code);
$test_text = implode("\n", $test_output);
if (function_exists('mb_convert_encoding')) {
    $test_text = @mb_convert_encoding($test_text, 'UTF-8', 'Windows-1252');
}

echo "   Return Code: $test_code\n";
echo "   Ausgabe: $test_text\n";

if (stripos($test_text, 'konnte nicht initialisiert werden') !== false) {
    echo "   ❌ Port kann immer noch nicht initialisiert werden\n";
} else {
    echo "   ✅ Test-Druck erfolgreich!\n";
}

@unlink($test_file);

echo "\n";
echo str_repeat("=", 60) . "\n";
echo "ZUSAMMENFASSUNG\n";
echo str_repeat("=", 60) . "\n\n";

echo "Wenn der Drucker immer noch 'Fehler' zeigt:\n\n";
echo "1. Öffne Windows-Einstellungen → Drucker\n";
echo "2. Rechtsklick auf 'LABELPRINTER SERVICE'\n";
echo "3. Wähle 'Problembehandlung ausführen'\n";
echo "4. Folge den Anweisungen\n\n";

echo "ODER:\n\n";
echo "1. Entferne den Drucker komplett\n";
echo "2. Verbinde ihn erneut über Windows Explorer:\n";
echo "   - Öffne: \\\\$server_ip\n";
echo "   - Rechtsklick auf 'labelprinter service'\n";
echo "   - 'Drucker verbinden'\n";
echo "   - WICHTIG: 'Anmeldedaten speichern' aktivieren\n\n";









