<?php
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/includes/hellomateo_api.php';

$autohausId = 1;

echo "=== Debug getApiKey() ===\n";
echo "Autohaus ID: {$autohausId}\n\n";

// Teste direkt die Datenbankabfrage
$db = new Database();
$conn = $db->getConnection();

echo "1. Direkte Datenbankabfrage:\n";
$stmt = $conn->prepare("SELECT whatsapp_api_key FROM autohaus WHERE id = ?");
$stmt->execute([$autohausId]);
$result = $stmt->fetch(PDO::FETCH_ASSOC);

if ($result) {
    $rawKey = $result['whatsapp_api_key'] ?? '';
    echo "  Raw API-Key Länge: " . strlen($rawKey) . "\n";
    echo "  Raw API-Key Präfix: " . substr($rawKey, 0, 50) . "...\n";
    echo "  Raw API-Key Type: " . gettype($rawKey) . "\n";
    echo "  Raw API-Key (erste 100 Zeichen): " . substr($rawKey, 0, 100) . "\n";
} else {
    echo "  ❌ Kein Ergebnis gefunden\n";
}

// Teste HelloMateoAPI
echo "\n2. HelloMateoAPI getApiKey():\n";
$api = new HelloMateoAPI(null, $autohausId);

// Verwende Reflection, um getApiKey() aufzurufen
$reflection = new ReflectionClass($api);
$method = $reflection->getMethod('getApiKey');
$method->setAccessible(true);
$apiKey = $method->invoke($api);

echo "  API-Key Länge: " . strlen($apiKey ?? '') . "\n";
echo "  API-Key Präfix: " . substr($apiKey ?? '', 0, 50) . "...\n";
echo "  API-Key Type: " . gettype($apiKey) . "\n";

// Prüfe auch die private $apiKey Property
$property = $reflection->getProperty('apiKey');
$property->setAccessible(true);
$storedApiKey = $property->getValue($api);

echo "\n3. Gespeicherter API-Key in HelloMateoAPI:\n";
echo "  API-Key Länge: " . strlen($storedApiKey ?? '') . "\n";
echo "  API-Key Präfix: " . substr($storedApiKey ?? '', 0, 50) . "...\n";
echo "  API-Key Type: " . gettype($storedApiKey) . "\n";





