<?php
/**
 * Erstellt die whatsapp_logs Tabelle
 */

require_once __DIR__ . '/../config/database.php';

try {
    $db = new Database();
    $conn = $db->getConnection();
    
    $conn->exec("
        CREATE TABLE IF NOT EXISTS whatsapp_logs (
            id INT AUTO_INCREMENT PRIMARY KEY,
            appointment_id INT,
            autohaus_id INT,
            phone_number VARCHAR(20),
            customer_name VARCHAR(255),
            action_type VARCHAR(50),
            status VARCHAR(20),
            message TEXT,
            error_message TEXT,
            created_at DATETIME,
            updated_at DATETIME,
            INDEX idx_appointment (appointment_id),
            INDEX idx_autohaus (autohaus_id),
            INDEX idx_status (status),
            INDEX idx_created (created_at)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4
    ");
    
    echo json_encode(['success' => true, 'message' => 'Tabelle whatsapp_logs wurde erstellt']);
} catch (Exception $e) {
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}




