<?php
/**
 * Erstellt einen Drucker-Port mit Authentifizierung
 * Versucht, den Port so zu konfigurieren, dass er mit Authentifizierung funktioniert
 */

require_once __DIR__ . '/../config/printer.php';

echo "🔧 Drucker-Port mit Authentifizierung erstellen\n";
echo str_repeat("=", 60) . "\n\n";

$printer_name = 'BUEK-PRT17';
$server_ip = PRINTER_SERVER_TAILSCALE_IP;
$server_user = PRINTER_SERVER_USER;
$server_pass = PRINTER_SERVER_PASS;

// 1. Stelle net use Verbindung her
echo "1. Stelle net use Verbindung her...\n";
$net_use_cmd = sprintf(
    'net use "\\\\%s" %s /user:%s /persistent:yes 2>&1',
    $server_ip,
    $server_pass ? escapeshellarg($server_pass) : '',
    escapeshellarg($server_user)
);
exec($net_use_cmd, $net_use_output, $net_use_code);
foreach ($net_use_output as $line) {
    echo "   $line\n";
}
echo "\n";

// 2. Prüfe vorhandene Ports
echo "2. Prüfe vorhandene Drucker-Ports...\n";
$port_check_cmd = 'powershell -NoProfile -ExecutionPolicy Bypass -Command "Get-PrinterPort | Select-Object Name, PrinterHostIP | Format-Table" 2>&1';
exec($port_check_cmd, $port_check_output, $port_check_code);
foreach ($port_check_output as $line) {
    echo "   $line\n";
}
echo "\n";

// 3. Versuche, einen TCP/IP-Port zu erstellen (falls der Drucker eine direkte IP hat)
echo "3. Versuche TCP/IP-Port zu erstellen...\n";
echo "   ⚠️ Hinweis: Für UNC-Ports muss der Drucker manuell verbunden werden\n";
echo "\n";

// 4. Erstelle eine PowerShell-Script-Datei für manuelle Ausführung
echo "4. Erstelle PowerShell-Script für manuelle Ausführung...\n";
$ps_script = <<<'POWERSHELL'
# PowerShell-Script zum Installieren von BUEK-PRT17
# Führen Sie dieses Script als Administrator aus!

$printerName = "BUEK-PRT17"
$serverIP = "100.82.207.72"
$serverUser = "VOLVOKIE\Projekt"
$serverPass = "start#2025"
$uncPath = "\\$serverIP\$printerName"

Write-Host "============================================================"
Write-Host "BUEK-PRT17 Drucker-Installation"
Write-Host "============================================================"
Write-Host ""

# 1. Net Use
Write-Host "1. Stelle net use Verbindung her..."
$netUseResult = net use "\\$serverIP" $serverPass /user:$serverUser
Write-Host "   $netUseResult"
Write-Host ""

# 2. Prüfe vorhandene Drucker
Write-Host "2. Prüfe vorhandene Drucker..."
$existingPrinter = Get-Printer -Name $printerName -ErrorAction SilentlyContinue
if ($existingPrinter) {
    Write-Host "   [INFO] Drucker bereits vorhanden"
    Write-Host "3. Lösche alten Drucker..."
    Remove-Printer -Name $printerName -ErrorAction SilentlyContinue
    Start-Sleep -Seconds 2
} else {
    Write-Host "   [INFO] Drucker noch nicht installiert"
}
Write-Host ""

# 3. Versuche Installation
Write-Host "4. Installiere Drucker..."
try {
    # Methode 1: Add-Printer mit ConnectionName
    Add-Printer -ConnectionName $uncPath -ErrorAction Stop
    Write-Host "   [OK] Installation erfolgreich (ConnectionName)"
} catch {
    Write-Host "   [FEHLER] ConnectionName fehlgeschlagen: $_"
    
    # Methode 2: Rundll32
    try {
        $process = Start-Process -FilePath "rundll32.exe" -ArgumentList "printui.dll,PrintUIEntry /in /n `"$uncPath`"" -Wait -NoNewWindow -PassThru
        if ($process.ExitCode -eq 0) {
            Write-Host "   [OK] Installation versucht (rundll32)"
            Start-Sleep -Seconds 3
        }
    } catch {
        Write-Host "   [FEHLER] rundll32 fehlgeschlagen: $_"
    }
}
Write-Host ""

# 4. Prüfe Installation
Write-Host "5. Prüfe Installation..."
$installedPrinter = Get-Printer -Name $printerName -ErrorAction SilentlyContinue
if ($installedPrinter) {
    Write-Host "   [OK] Drucker installiert!"
    Write-Host "   Status: $($installedPrinter.PrinterStatus)"
    Write-Host "   Port: $($installedPrinter.PortName)"
    Write-Host ""
    Write-Host "============================================================"
    Write-Host "ERFOLG: Drucker installiert!"
    Write-Host "============================================================"
} else {
    Write-Host "   [FEHLER] Drucker nicht gefunden"
    Write-Host ""
    Write-Host "============================================================"
    Write-Host "MANUELLE INSTALLATION ERFORDERLICH:"
    Write-Host "============================================================"
    Write-Host "1. Öffne Windows Explorer"
    Write-Host "2. Gebe ein: \\$serverIP"
    Write-Host "3. Rechtsklick auf '$printerName'"
    Write-Host "4. Wähle 'Drucker verbinden'"
    Write-Host "5. Verwende Credentials: $serverUser"
    Write-Host ""
    Write-Host "Öffne Windows Explorer..."
    Start-Process "explorer.exe" -ArgumentList "\\$serverIP"
}

Write-Host ""
Read-Host "Drücken Sie Enter zum Beenden"
POWERSHELL;

$ps_file = __DIR__ . '/install_buek_prt17.ps1';
file_put_contents($ps_file, $ps_script);
echo "   ✅ PowerShell-Script erstellt: $ps_file\n";
echo "\n";

// 5. Erstelle auch eine einfache Anleitung
echo "5. Erstelle Installations-Anleitung...\n";
$readme = <<<README
# BUEK-PRT17 Drucker-Installation

## Problem
Der Drucker BUEK-PRT17 von buek-s01 (100.82.207.72) kann nicht automatisch 
installiert werden, da Windows die Authentifizierung für UNC-Ports nicht 
automatisch speichert.

## Lösung: Manuelle Installation

### Methode 1: Windows Explorer (EMPFOHLEN)

1. Öffne Windows Explorer
2. Gebe in der Adresszeile ein: \\\\100.82.207.72
3. Rechtsklick auf "BUEK-PRT17"
4. Wähle "Drucker verbinden" oder "Connect"
5. Bei Credentials-Abfrage:
   - Benutzer: VOLVOKIE\\Projekt
   - Passwort: start#2025
6. Warte, bis Installation abgeschlossen ist
7. Prüfe in Windows-Einstellungen → Drucker

### Methode 2: PowerShell als Administrator

1. Öffne PowerShell als Administrator
2. Führe aus: .\\admin\\install_buek_prt17.ps1
3. Oder kopiere den Inhalt und führe ihn aus

### Methode 3: Batch-Datei als Administrator

1. Rechtsklick auf admin\\install_printer_as_admin.bat
2. Wähle "Als Administrator ausführen"
3. Folge den Anweisungen

## Nach der Installation

1. Prüfe, ob der Drucker in Windows-Einstellungen sichtbar ist
2. Versuche Windows-Testseite zu drucken
3. Falls erfolgreich, sollte die API auch funktionieren

## Warum manuell?

Windows speichert die Authentifizierung für Drucker-Ports nur, wenn der 
Drucker über Windows Explorer verbunden wird. Automatische Installation 
über PowerShell/rundll32 speichert die Credentials nicht korrekt für UNC-Ports.
README;

$readme_file = __DIR__ . '/INSTALL_PRINTER_README.md';
file_put_contents($readme_file, $readme);
echo "   ✅ Anleitung erstellt: $readme_file\n";
echo "\n";

// Zusammenfassung
echo str_repeat("=", 60) . "\n";
echo "ZUSAMMENFASSUNG\n";
echo str_repeat("=", 60) . "\n\n";

echo "✅ Dateien erstellt:\n";
echo "   1. admin/install_printer_as_admin.bat (Batch-Datei)\n";
echo "   2. admin/install_buek_prt17.ps1 (PowerShell-Script)\n";
echo "   3. admin/INSTALL_PRINTER_README.md (Anleitung)\n";
echo "\n";

echo "📋 NÄCHSTE SCHRITTE:\n";
echo "\n";
echo "OPTION 1 - Windows Explorer (EINFACHSTE METHODE):\n";
echo "   1. Öffne Windows Explorer\n";
echo "   2. Gebe ein: \\\\$server_ip\n";
echo "   3. Rechtsklick auf '$printer_name' → 'Drucker verbinden'\n";
echo "   4. Credentials: $server_user / [Passwort]\n";
echo "\n";

echo "OPTION 2 - PowerShell als Administrator:\n";
echo "   1. Öffne PowerShell als Administrator\n";
echo "   2. cd C:\\xampp\\htdocs\\boxenstop\\admin\n";
echo "   3. .\\install_buek_prt17.ps1\n";
echo "\n";

echo "OPTION 3 - Batch-Datei als Administrator:\n";
echo "   1. Rechtsklick auf admin\\install_printer_as_admin.bat\n";
echo "   2. 'Als Administrator ausführen'\n";
echo "\n";

echo "💡 EMPFEHLUNG: Verwende OPTION 1 (Windows Explorer)\n";
echo "   Das ist die zuverlässigste Methode!\n";









