<?php
/**
 * Verbindet BUEK-PRT17 über buek-s01 (wie im Windows Explorer sichtbar)
 */

require_once __DIR__ . '/../config/printer.php';

echo "🔌 BUEK-PRT17 Verbindung über buek-s01\n";
echo str_repeat("=", 60) . "\n\n";

$printer_name_server = 'BUEK-PRT17';
$server_hostname = PRINTER_SERVER_HOSTNAME;
$server_ip = PRINTER_SERVER_TAILSCALE_IP;
$server_user = PRINTER_SERVER_USER;
$server_pass = PRINTER_SERVER_PASS;

echo "Drucker: $printer_name_server\n";
echo "Server Hostname: $server_hostname\n";
echo "Server IP (Tailscale): $server_ip\n";
echo "Benutzer: $server_user\n\n";

// 1. Stelle net use Verbindung her
echo "1. Stelle net use Verbindung her...\n";
$net_use_cmd = sprintf(
    'net use "\\\\%s" %s /user:%s /persistent:yes 2>&1',
    $server_hostname,
    $server_pass ? escapeshellarg($server_pass) : '',
    escapeshellarg($server_user)
);
exec($net_use_cmd, $net_use_output, $net_use_code);
foreach ($net_use_output as $line) {
    if (trim($line)) {
        echo "   $line\n";
    }
}
echo "\n";

// 2. Prüfe, ob Drucker bereits lokal installiert ist
echo "2. Prüfe, ob Drucker bereits lokal installiert ist...\n";
$check_cmd = sprintf(
    'powershell -NoProfile -ExecutionPolicy Bypass -Command "try { $p = Get-Printer -Name \'%s\' -ErrorAction SilentlyContinue; if ($p) { Write-Host \"⚠️ Drucker bereits installiert: $($p.Name)\"; Write-Host \"Status: $($p.PrinterStatus)\"; Write-Host \"Port: $($p.PortName)\" } else { Write-Host \"✅ Drucker noch nicht installiert\" } } catch { Write-Host \"✅ Drucker noch nicht installiert\" }" 2>&1',
    str_replace("'", "''", $printer_name_server)
);
exec($check_cmd, $check_output, $check_code);
foreach ($check_output as $line) {
    echo "   $line\n";
}
echo "\n";

// 3. Öffne Windows Explorer auf buek-s01
echo "3. Öffne Windows Explorer auf buek-s01...\n";
$explorer_cmd = sprintf('explorer "\\\\%s"', $server_hostname);
exec($explorer_cmd);
echo "   ✅ Windows Explorer geöffnet\n";
echo "\n";

echo str_repeat("=", 60) . "\n";
echo "📋 WICHTIGE ANLEITUNG FÜR MANUELLE VERBINDUNG:\n";
echo str_repeat("=", 60) . "\n\n";

echo "⚠️⚠️⚠️ DIESER SCHRITT IST ZWINGEND ERFORDERLICH! ⚠️⚠️⚠️\n\n";

echo "Im geöffneten Windows Explorer sollte 'BUEK-PRT17' sichtbar sein\n";
echo "(Drucker-Icon, wie in deinem Screenshot).\n\n";

echo "SCHRITT-FÜR-SCHRITT:\n\n";

echo "1. Im Windows Explorer:\n";
echo "   - Suche nach 'BUEK-PRT17' (Drucker-Icon)\n";
echo "   - Falls nicht sichtbar, aktualisiere die Ansicht (F5)\n\n";

echo "2. Rechtsklick auf 'BUEK-PRT17':\n";
echo "   - Wähle 'Drucker verbinden' oder 'Connect'\n\n";

echo "3. Wenn nach Credentials gefragt wird:\n";
echo "   Benutzer: $server_user\n";
echo "   Passwort: $server_pass\n";
echo "   ☑️☑️☑️ 'Anmeldedaten speichern' MUSS aktiviert sein! ☑️☑️☑️\n\n";

echo "4. Warte, bis die Installation abgeschlossen ist\n";
echo "   (Windows zeigt eine Benachrichtigung)\n\n";

echo "5. Prüfe in Windows-Einstellungen → Drucker:\n";
echo "   - Der Drucker sollte als '$printer_name_server' erscheinen\n";
echo "   - Status sollte 'Bereit' oder 'Normal' sein (NICHT 'Fehler'!)\n\n";

echo "6. Teste Windows-Testseite:\n";
echo "   - Rechtsklick auf Drucker → 'Druckereigenschaften'\n";
echo "   - 'Testseite drucken'\n";
echo "   - Falls erfolgreich: ✅ Drucker funktioniert!\n\n";

echo str_repeat("=", 60) . "\n";
echo "🔍 NACH DER VERBINDUNG:\n";
echo str_repeat("=", 60) . "\n\n";

echo "Führen Sie aus:\n";
echo "  php admin/verify_prt17_connection.php\n\n";

echo "💡 HINWEIS:\n";
echo "Da BUEK-PRT17 im Windows Explorer auf buek-s01 sichtbar ist,\n";
echo "sollte die Verbindung über diesen Weg funktionieren, auch wenn\n";
echo "der Drucker nicht in 'net view' erscheint.\n\n";









