<?php
/**
 * Versucht BUEK-PRT17 direkt zu verbinden (auch wenn net view ihn nicht zeigt)
 */

require_once __DIR__ . '/../config/printer.php';

echo "🔌 BUEK-PRT17 Direktverbindung\n";
echo str_repeat("=", 60) . "\n\n";

$printer_name_server = 'BUEK-PRT17';
$server_ip = PRINTER_SERVER_TAILSCALE_IP;
$server_user = PRINTER_SERVER_USER;
$server_pass = PRINTER_SERVER_PASS;

echo "Drucker: $printer_name_server\n";
echo "Server: $server_ip\n";
echo "Benutzer: $server_user\n\n";

// 1. Stelle net use Verbindung her
echo "1. Stelle net use Verbindung her...\n";
$net_use_cmd = sprintf(
    'net use "\\\\%s" %s /user:%s /persistent:yes 2>&1',
    $server_ip,
    $server_pass ? escapeshellarg($server_pass) : '',
    escapeshellarg($server_user)
);
exec($net_use_cmd, $net_use_output, $net_use_code);
foreach ($net_use_output as $line) {
    if (trim($line)) {
        echo "   $line\n";
    }
}
echo "\n";

// 2. Versuche direkten Zugriff über UNC
echo "2. Versuche direkten Zugriff über UNC...\n";
$unc_path = "\\\\$server_ip\\$printer_name_server";
echo "   UNC-Pfad: $unc_path\n";

$test_cmd = sprintf('dir "%s" 2>&1', $unc_path);
exec($test_cmd, $test_output, $test_code);
$test_text = implode(' ', $test_output);
if (function_exists('mb_convert_encoding')) {
    $test_text = @mb_convert_encoding($test_text, 'UTF-8', 'Windows-1252');
}

if ($test_code === 0) {
    echo "   ✅ Zugriff erfolgreich!\n";
} else {
    echo "   ⚠️ Direkter Zugriff nicht möglich: $test_text\n";
}
echo "\n";

// 3. Versuche Installation über PowerShell
echo "3. Versuche Installation über PowerShell...\n";
$ps_script = sprintf(
    'powershell -NoProfile -ExecutionPolicy Bypass -Command "try { $printer = Get-Printer -Name \'%s\' -ErrorAction SilentlyContinue; if ($printer) { Write-Host \"⚠️ Drucker bereits installiert: $($printer.Name)\" } else { Add-Printer -ConnectionName \'%s\' -ErrorAction Stop; Write-Host \"✅ Drucker erfolgreich installiert!\" } } catch { Write-Host \"❌ Fehler: $_\" }" 2>&1',
    str_replace("'", "''", $printer_name_server),
    str_replace("'", "''", $unc_path)
);
exec($ps_script, $ps_output, $ps_code);
foreach ($ps_output as $line) {
    echo "   $line\n";
}
echo "\n";

// 4. Öffne Windows Explorer für manuelle Verbindung
echo "4. Öffne Windows Explorer für manuelle Verbindung...\n";
echo "   Versuche direkten UNC-Pfad zu öffnen...\n";
$explorer_cmd = sprintf('explorer "%s"', $unc_path);
exec($explorer_cmd);
echo "   ✅ Windows Explorer geöffnet\n";
echo "\n";

echo str_repeat("=", 60) . "\n";
echo "📋 ANLEITUNG FÜR MANUELLE VERBINDUNG:\n";
echo str_repeat("=", 60) . "\n\n";

echo "Falls Windows Explorer geöffnet wurde:\n\n";

echo "1. Falls der Drucker sichtbar ist:\n";
echo "   - Rechtsklick auf 'BUEK-PRT17'\n";
echo "   - 'Drucker verbinden' oder 'Connect'\n";
echo "   - Credentials: $server_user / [Passwort]\n";
echo "   - ☑️ 'Anmeldedaten speichern' aktivieren\n\n";

echo "2. Falls der Drucker NICHT sichtbar ist:\n";
echo "   - Schließe den Explorer\n";
echo "   - Öffne Windows Explorer\n";
echo "   - Gebe in die Adresszeile ein: $unc_path\n";
echo "   - Drücke Enter\n";
echo "   - Falls nach Credentials gefragt wird:\n";
echo "     Benutzer: $server_user\n";
echo "     Passwort: [Passwort]\n";
echo "     ☑️ 'Anmeldedaten speichern' aktivieren\n\n";

echo "3. Nach erfolgreicher Verbindung:\n";
echo "   - Prüfe in Windows-Einstellungen → Drucker\n";
echo "   - Der Drucker sollte als 'BUEK-PRT17' erscheinen\n";
echo "   - Status sollte 'Bereit' sein\n\n";

echo "4. Teste die Verbindung:\n";
echo "   php admin/verify_prt17_connection.php\n\n";









