<?php
/**
 * Prüft, ob BUEK-PRT17 auf dem Server sichtbar ist
 */

require_once __DIR__ . '/../config/printer.php';

echo "🔍 Prüfe BUEK-PRT17 Sichtbarkeit\n";
echo str_repeat("=", 60) . "\n\n";

$server_ip = PRINTER_SERVER_TAILSCALE_IP;
$server_hostname = PRINTER_SERVER_HOSTNAME;
$printer_name = 'BUEK-PRT17';

echo "Drucker-Name: $printer_name\n";
echo "Server IP: $server_ip\n";
echo "Server Hostname: $server_hostname\n\n";

// 1. Prüfe über net view
echo "1. Prüfe über net view...\n";
$net_view_cmd = sprintf('net view "\\\\%s" 2>&1', $server_ip);
exec($net_view_cmd, $net_view_output, $net_view_code);
$found_in_net_view = false;
foreach ($net_view_output as $line) {
    echo "   $line\n";
    if (stripos($line, 'BUEK-PRT17') !== false || 
        (stripos($line, 'BUEK') !== false && stripos($line, 'Drucker') !== false)) {
        $found_in_net_view = true;
        echo "      ✅✅✅ BUEK-PRT17 in net view gefunden!\n";
    }
}
echo "\n";

// 2. Versuche direkten Zugriff über UNC
echo "2. Versuche direkten Zugriff über UNC...\n";
$unc_paths = [
    "\\\\$server_ip\\$printer_name",
    "\\\\$server_hostname\\$printer_name",
    "\\\\$server_ip\\BUEK-PRT17",
    "\\\\$server_hostname\\BUEK-PRT17"
];

foreach ($unc_paths as $unc_path) {
    echo "   Prüfe: $unc_path\n";
    $test_cmd = sprintf('dir "%s" 2>&1', $unc_path);
    exec($test_cmd, $test_output, $test_code);
    if ($test_code === 0) {
        echo "      ✅ Zugriff erfolgreich!\n";
    } else {
        $error = implode(' ', $test_output);
        if (stripos($error, 'Zugriff verweigert') !== false || 
            stripos($error, 'Access denied') !== false) {
            echo "      ⚠️ Zugriff verweigert (Berechtigung fehlt)\n";
        } elseif (stripos($error, 'Netzwerkpfad nicht gefunden') !== false ||
                  stripos($error, 'network path') !== false) {
            echo "      ❌ Nicht gefunden\n";
        } else {
            echo "      ⚠️ $error\n";
        }
    }
}
echo "\n";

// 3. Prüfe über PowerShell Get-Printer auf Server
echo "3. Prüfe über PowerShell Get-Printer auf Server...\n";
$ps_cmd = sprintf(
    'powershell -NoProfile -ExecutionPolicy Bypass -Command "try { $printers = Get-Printer -ComputerName \'%s\' -ErrorAction Stop | Where-Object { $_.Name -like \'*BUEK*\' -or $_.Name -like \'*PRT17*\' }; if ($printers) { foreach ($p in $printers) { Write-Host \"✅ $($p.Name) - Status: $($p.PrinterStatus) - Shared: $($p.Shared)\" } } else { Write-Host \"❌ Keine BUEK-PRT17 Drucker gefunden\" } } catch { Write-Host \"⚠️ Fehler: $_\" }" 2>&1',
    $server_ip
);
exec($ps_cmd, $ps_output, $ps_code);
foreach ($ps_output as $line) {
    echo "   $line\n";
}
echo "\n";

// 4. Zusammenfassung
echo str_repeat("=", 60) . "\n";
echo "ZUSAMMENFASSUNG\n";
echo str_repeat("=", 60) . "\n\n";

if ($found_in_net_view) {
    echo "✅✅✅ BUEK-PRT17 IST ÜBER NET VIEW SICHTBAR!\n\n";
    echo "Der Drucker kann jetzt verbunden werden:\n";
    echo "  php admin/connect_prt17.php\n\n";
} else {
    echo "❌ BUEK-PRT17 IST NICHT ÜBER NET VIEW SICHTBAR!\n\n";
    echo "⚠️⚠️⚠️ WICHTIG: Obwohl der Drucker auf dem Server freigegeben ist,\n";
    echo "wird er nicht über net view angezeigt.\n\n";
    
    echo "MÖGLICHE LÖSUNGEN:\n\n";
    
    echo "1. Auf dem Server (100.82.207.72) prüfen:\n";
    echo "   - Öffne PowerShell als Administrator\n";
    echo "   - Führe aus: Restart-Service Spooler\n";
    echo "   - Warte 10 Sekunden\n";
    echo "   - Prüfe erneut: net view \\\\100.82.207.72\n\n";
    
    echo "2. Prüfe Drucker-Freigabe auf dem Server:\n";
    echo "   - Systemsteuerung → Geräte und Drucker\n";
    echo "   - Rechtsklick auf 'BUEK-PRT17'\n";
    echo "   - Druckereigenschaften → Freigabe\n";
    echo "   - Stelle sicher, dass 'Drucker freigeben' aktiviert ist\n";
    echo "   - Freigabename sollte 'BUEK-PRT17' sein\n";
    echo "   - Klicke 'OK'\n\n";
    
    echo "3. Prüfe Berechtigungen:\n";
    echo "   - Druckereigenschaften → Sicherheit\n";
    echo "   - Stelle sicher, dass 'Jeder' oder 'VOLVOKIE\\Projekt' Druckberechtigung hat\n\n";
    
    echo "4. Nach Änderungen auf dem Server:\n";
    echo "   - Warte 30 Sekunden\n";
    echo "   - Führe erneut aus: php admin/check_buek_prt17_visibility.php\n\n";
    
    echo "5. ALTERNATIVE: Direkter Verbindungsversuch\n";
    echo "   Auch wenn net view den Drucker nicht zeigt, kann er manchmal\n";
    echo "   direkt verbunden werden:\n";
    echo "   - Öffne Windows Explorer\n";
    echo "   - Gebe ein: \\\\100.82.207.72\\BUEK-PRT17\n";
    echo "   - Falls nach Credentials gefragt wird: VOLVOKIE\\Projekt / start#2025\n";
    echo "   - 'Anmeldedaten speichern' aktivieren\n\n";
}









