<?php
session_start();
require_once '../../config/database.php';
require_once '../includes/whatsapp_2fa.php';

// Check if user is logged in
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    http_response_code(401);
    echo json_encode(['success' => false, 'error' => 'Nicht autorisiert']);
    exit;
}

$db = new Database();
$conn = $db->getConnection();

// Prüfe ob Code-Verifizierung oder Code-Versand
if (isset($_POST['action']) && $_POST['action'] === 'verify_code') {
    // Code-Verifizierung
    if (!isset($_POST['user_id']) || !is_numeric($_POST['user_id']) || !isset($_POST['code'])) {
        http_response_code(400);
        echo json_encode(['success' => false, 'error' => 'Ungültige Parameter']);
        exit;
    }
    
    $user_id = (int)$_POST['user_id'];
    $code = trim($_POST['code']);
    
    try {
        $result = verifyPhoneNumberWithCode($user_id, $code);
        echo json_encode($result);
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode(['success' => false, 'error' => 'Fehler bei der Verifizierung: ' . $e->getMessage()]);
    }
    exit;
}

// Code-Versand
if (!isset($_POST['user_id']) || !is_numeric($_POST['user_id'])) {
    http_response_code(400);
    echo json_encode(['success' => false, 'error' => 'Ungültige Benutzer-ID']);
    exit;
}

$user_id = (int)$_POST['user_id'];

try {
    // Hole Benutzerdaten mit Telefonnummer
    $stmt = $conn->prepare("
        SELECT u.id, u.autohaus_id, 
               COALESCE(u.phone, tfa.phone) as phone
        FROM admin_users u
        LEFT JOIN admin_user_2fa tfa ON u.id = tfa.user_id
        WHERE u.id = ?
    ");
    $stmt->execute([$user_id]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$user) {
        http_response_code(404);
        echo json_encode(['success' => false, 'error' => 'Benutzer nicht gefunden']);
        exit;
    }
    
    if (empty($user['phone'])) {
        http_response_code(400);
        echo json_encode(['success' => false, 'error' => 'Keine Telefonnummer für diesen Benutzer hinterlegt']);
        exit;
    }
    
    // Sende Verifizierungscode (ohne automatische Verifizierung)
    $result = sendPhoneVerificationCode($user_id, $user['phone'], $user['autohaus_id']);
    
    if ($result['success']) {
        echo json_encode([
            'success' => true, 
            'message' => 'Ein Verifizierungscode wurde per WhatsApp gesendet. Bitte geben Sie den Code ein.',
            'code_sent' => true
        ]);
    } else {
        echo json_encode([
            'success' => false, 
            'error' => $result['error'] ?? 'Fehler beim Senden des Codes',
            'code_sent' => false
        ]);
    }
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'error' => 'Fehler beim Senden des Codes: ' . $e->getMessage()]);
}
?>

