<?php
/**
 * AJAX-Endpoint: Aktualisiert Session-Einstellungen mit Re-Auth
 */

session_start();
header('Content-Type: application/json');

if (!isset($_SESSION['admin_logged_in']) || !$_SESSION['admin_logged_in']) {
    echo json_encode(['success' => false, 'error' => 'Nicht autorisiert']);
    exit;
}

$admin_user_id = $_SESSION['admin_user_id'] ?? null;
$password = $_POST['password'] ?? '';

if (empty($password)) {
    echo json_encode(['success' => false, 'error' => 'Passwort erforderlich']);
    exit;
}

try {
    require_once '../../config/database.php';
    $db = new Database();
    $conn = $db->getConnection();
    
    // Re-Auth: Passwort prüfen
    $stmt = $conn->prepare("SELECT password FROM admin_users WHERE id = ?");
    $stmt->execute([$admin_user_id]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$user || !password_verify($password, $user['password'])) {
        echo json_encode(['success' => false, 'error' => 'Falsches Passwort']);
        exit;
    }
    
    // Session-Einstellungen aktualisieren
    $settings = [
        'session_gc_maxlifetime' => intval($_POST['gc_maxlifetime'] ?? 3600),
        'session_cookie_lifetime' => intval($_POST['cookie_lifetime'] ?? 0),
        'session_regenerate_interval' => intval($_POST['regenerate_interval'] ?? 1800)
    ];
    
    // Validierung
    if ($settings['session_gc_maxlifetime'] < 300 || $settings['session_gc_maxlifetime'] > 86400) {
        echo json_encode(['success' => false, 'error' => 'gc_maxlifetime muss zwischen 300 und 86400 Sekunden liegen']);
        exit;
    }
    
    if ($settings['session_cookie_lifetime'] < 0 || $settings['session_cookie_lifetime'] > 86400) {
        echo json_encode(['success' => false, 'error' => 'cookie_lifetime muss zwischen 0 und 86400 Sekunden liegen']);
        exit;
    }
    
    if ($settings['session_regenerate_interval'] < 60 || $settings['session_regenerate_interval'] > 7200) {
        echo json_encode(['success' => false, 'error' => 'regenerate_interval muss zwischen 60 und 7200 Sekunden liegen']);
        exit;
    }
    
    // Speichere in settings-Tabelle
    foreach ($settings as $key => $value) {
        $stmt = $conn->prepare("INSERT INTO settings (setting_key, setting_value) VALUES (?, ?) ON DUPLICATE KEY UPDATE setting_value = ?");
        $stmt->execute([$key, $value, $value]);
    }
    
    echo json_encode([
        'success' => true,
        'message' => 'Session-Einstellungen erfolgreich aktualisiert',
        'settings' => $settings
    ]);
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
?>
















