<?php
/**
 * API: Feedback Status aktualisieren
 */

session_start();
require_once '../../config/database.php';

header('Content-Type: application/json');

if (!isset($_SESSION['admin_logged_in']) || !$_SESSION['admin_logged_in']) {
    http_response_code(401);
    echo json_encode(['success' => false, 'error' => 'Nicht autorisiert']);
    exit;
}

$input = json_decode(file_get_contents('php://input'), true);

if (!isset($input['feedback_id']) || !isset($input['status'])) {
    http_response_code(400);
    echo json_encode(['success' => false, 'error' => 'Fehlende Parameter']);
    exit;
}

$feedback_id = (int)$input['feedback_id'];
$status = $input['status'];

if (!in_array($status, ['new', 'read', 'archived'])) {
    http_response_code(400);
    echo json_encode(['success' => false, 'error' => 'Ungültiger Status']);
    exit;
}

try {
    $db = new Database();
    $conn = $db->getConnection();
    
    // Hole alten Status für Audit-Log
    $oldStmt = $conn->prepare("SELECT status FROM feedback WHERE id = ?");
    $oldStmt->execute([$feedback_id]);
    $oldData = $oldStmt->fetch(PDO::FETCH_ASSOC);
    $oldStatus = $oldData['status'] ?? null;
    
    $current_user_id = $_SESSION['admin_user_id'] ?? null;
    
    $stmt = $conn->prepare("UPDATE feedback SET status = ? WHERE id = ?");
    $result = $stmt->execute([$status, $feedback_id]);
    
    if ($result) {
        // Audit-Log: Status geändert
        try {
            $checkTable = $conn->query("SHOW TABLES LIKE 'feedback_audit_log'");
            if ($checkTable->rowCount() > 0) {
                $statusLabels = [
                    'new' => 'Neu',
                    'read' => 'Gelesen',
                    'archived' => 'Archiviert'
                ];
                
                $auditStmt = $conn->prepare("
                    INSERT INTO feedback_audit_log 
                    (feedback_id, admin_user_id, action_type, action_description, old_value, new_value)
                    VALUES (?, ?, 'status_changed', 'Status geändert', ?, ?)
                ");
                $auditStmt->execute([
                    $feedback_id,
                    $current_user_id,
                    $oldStatus ? $statusLabels[$oldStatus] ?? $oldStatus : null,
                    $statusLabels[$status] ?? $status
                ]);
            }
        } catch (PDOException $auditError) {
            error_log("Fehler beim Erstellen des Audit-Logs: " . $auditError->getMessage());
        }
        
        echo json_encode([
            'success' => true,
            'message' => 'Status erfolgreich aktualisiert'
        ]);
    } else {
        http_response_code(500);
        echo json_encode([
            'success' => false,
            'error' => 'Fehler beim Aktualisieren des Status'
        ]);
    }
    
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => 'Fehler beim Aktualisieren des Status'
    ]);
}

