<?php
/**
 * Test Suspend API with proper session
 */

session_start();

// Set admin session for testing
$_SESSION['admin_logged_in'] = true;
$_SESSION['admin_id'] = 1; // Assuming admin ID 1 exists

echo "Session set for testing:\n";
echo "admin_logged_in: " . ($_SESSION['admin_logged_in'] ? 'true' : 'false') . "\n";
echo "admin_id: " . $_SESSION['admin_id'] . "\n";

// Test the suspend API
$testData = [
    'user_id' => 10, // Test with user ID 10
    'action' => 'suspend',
    'reason' => 'Test suspension'
];

echo "\nTesting suspend API...\n";

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, 'http://localhost:8000/admin/api/suspend_user.php');
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($testData));
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json',
    'Cookie: ' . session_name() . '=' . session_id()
]);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

echo "HTTP Code: $httpCode\n";
echo "Response: $response\n";

if ($response) {
    $decoded = json_decode($response, true);
    if ($decoded) {
        echo "Decoded response:\n";
        print_r($decoded);
    } else {
        echo "Failed to decode JSON response\n";
    }
}
?>
