<?php
/**
 * Save Widget Order API
 * Speichert die Reihenfolge der Widgets pro Benutzer
 */

session_start();
require_once '../../config/database_optimized.php';

// Check if user is logged in
if (!isset($_SESSION['admin_logged_in']) || !$_SESSION['admin_logged_in']) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'error' => 'Nicht angemeldet']);
    exit;
}

$db = DatabaseOptimized::getInstance();
$conn = $db->getConnection();
$current_user_id = $_SESSION['admin_user_id'] ?? null;

header('Content-Type: application/json');

try {
    $input = json_decode(file_get_contents('php://input'), true);
    $widget_order = $input['widget_order'] ?? [];
    
    // Get current user config
    $stmt = $conn->prepare("SELECT config_data FROM user_dashboard_config WHERE user_id = ?");
    $stmt->execute([$current_user_id]);
    $result = $stmt->fetch();
    
    $config = [];
    if ($result) {
        $config = json_decode($result['config_data'], true);
    }
    
    // Update widget order
    $config['widget_order'] = $widget_order;
    
    // Save updated config
    $stmt = $conn->prepare("
        INSERT INTO user_dashboard_config (user_id, config_data, created_at, updated_at) 
        VALUES (?, ?, NOW(), NOW())
        ON DUPLICATE KEY UPDATE 
        config_data = VALUES(config_data), updated_at = NOW()
    ");
    $stmt->execute([$current_user_id, json_encode($config)]);
    
    echo json_encode(['success' => true, 'message' => 'Widget-Reihenfolge gespeichert']);
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}

