<?php
/**
 * API: Speichere Template-Konfiguration
 */

require_once __DIR__ . '/../../config/database.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'error' => 'Nur POST erlaubt']);
    exit;
}

$db = new Database();
$conn = $db->getConnection();

$data = json_decode(file_get_contents('php://input'), true);

$autohausId = $data['autohaus_id'] ?? null;
$actionType = $data['action_type'] ?? null;
$templateId = $data['template_id'] ?? null;
$sendTiming = $data['send_timing'] ?? null;
$sendTimingHours = $data['send_timing_hours'] ?? null;
$isActive = $data['is_active'] ?? 1;
$customFieldsMapping = $data['custom_fields_mapping'] ?? [];

if (!$autohausId || !$actionType || !$templateId) {
    echo json_encode(['success' => false, 'error' => 'Autohaus-ID, Aktion und Template-ID sind erforderlich']);
    exit;
}

try {
    // Prüfe ob bereits existiert
    $stmt = $conn->prepare("SELECT id FROM whatsapp_template_configs WHERE autohaus_id = ? AND action_type = ?");
    $stmt->execute([$autohausId, $actionType]);
    $existing = $stmt->fetch(PDO::FETCH_ASSOC);
    
    $customFieldsJson = json_encode($customFieldsMapping);
    
    if ($existing) {
        // Update
        $stmt = $conn->prepare("
            UPDATE whatsapp_template_configs 
            SET template_id = ?, 
                send_timing = ?, 
                send_timing_hours = ?, 
                is_active = ?, 
                custom_fields_mapping = ?,
                updated_at = NOW()
            WHERE id = ?
        ");
        $stmt->execute([$templateId, $sendTiming, $sendTimingHours, $isActive, $customFieldsJson, $existing['id']]);
    } else {
        // Insert
        $stmt = $conn->prepare("
            INSERT INTO whatsapp_template_configs 
            (autohaus_id, action_type, template_id, send_timing, send_timing_hours, is_active, custom_fields_mapping)
            VALUES (?, ?, ?, ?, ?, ?, ?)
        ");
        $stmt->execute([$autohausId, $actionType, $templateId, $sendTiming, $sendTimingHours, $isActive, $customFieldsJson]);
    }
    
    echo json_encode(['success' => true, 'message' => 'Template-Konfiguration gespeichert']);
} catch (Exception $e) {
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}





