<?php
/**
 * API: Hole WhatsApp-Logs für Test-UI
 */

session_start();
require_once __DIR__ . '/../../config/database.php';

header('Content-Type: application/json');

// Prüfe ob Admin eingeloggt ist
if (!isset($_SESSION['admin_logged_in']) || !$_SESSION['admin_logged_in']) {
    echo json_encode(['success' => false, 'error' => 'Nicht autorisiert']);
    exit;
}

$db = new Database();
$conn = $db->getConnection();

$autohausId = $_GET['autohaus_id'] ?? null;
$phone = $_GET['phone'] ?? null;
$limit = intval($_GET['limit'] ?? 50);

try {
    $where = ['1=1'];
    $params = [];
    
    if ($autohausId) {
        $where[] = 'wl.autohaus_id = ?';
        $params[] = $autohausId;
    }
    
    if ($phone) {
        $where[] = 'wl.phone_number = ?';
        $params[] = $phone;
    }
    
    $whereClause = implode(' AND ', $where);
    
    $stmt = $conn->prepare("
        SELECT wl.*, a.name as autohaus_name
        FROM whatsapp_logs wl
        LEFT JOIN autohaus a ON wl.autohaus_id = a.id
        WHERE $whereClause
        ORDER BY wl.created_at DESC
        LIMIT ?
    ");
    
    $params[] = $limit;
    $stmt->execute($params);
    $logs = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo json_encode(['success' => true, 'logs' => $logs]);
} catch (Exception $e) {
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}




