<?php
/**
 * API: Hole Template-Konfigurationen für ein Autohaus
 */

require_once __DIR__ . '/../../config/database.php';

header('Content-Type: application/json');

$db = new Database();
$conn = $db->getConnection();

$autohausId = $_GET['autohaus_id'] ?? null;

if (!$autohausId) {
    echo json_encode(['success' => false, 'error' => 'Autohaus-ID fehlt']);
    exit;
}

try {
    $stmt = $conn->prepare("
        SELECT * FROM whatsapp_template_configs 
        WHERE autohaus_id = ? 
        ORDER BY action_type ASC
    ");
    $stmt->execute([$autohausId]);
    $configs = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Parse custom_fields_mapping JSON
    foreach ($configs as &$config) {
        if (!empty($config['custom_fields_mapping'])) {
            $config['custom_fields_mapping'] = json_decode($config['custom_fields_mapping'], true);
        } else {
            $config['custom_fields_mapping'] = [];
        }
    }
    
    echo json_encode(['success' => true, 'data' => $configs]);
} catch (Exception $e) {
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}





